/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.player;

import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.network.message.player.SPacketUpdatePlayerCache;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class CPacketRequestName
extends ClientToServerPacket {
    private static final CustomPacketPayload.Type<CPacketRequestName> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("c_player_name_request"));
    public static final CustomPacket.Handler<CPacketRequestName> HANDLER = new H();
    private final UUID playerID;

    public CPacketRequestName(@Nonnull UUID playerID) {
        super(TYPE);
        this.playerID = playerID;
    }

    private static void encode(@Nonnull FriendlyByteBuf buffer, @Nonnull CPacketRequestName message) {
        buffer.writeUUID(message.playerID);
    }

    private static CPacketRequestName decode(@Nonnull FriendlyByteBuf buffer) {
        return new CPacketRequestName(buffer.readUUID());
    }

    private static class H
    extends CustomPacket.Handler<CPacketRequestName> {
        protected H() {
            super(TYPE, StreamCodec.of(CPacketRequestName::encode, CPacketRequestName::decode));
        }

        @Override
        protected void handle(@Nonnull CPacketRequestName message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            String name = PlayerReference.getPlayerName(message.playerID);
            if (name != null) {
                context.reply((CustomPacketPayload)new SPacketUpdatePlayerCache(message.playerID, name));
            }
        }
    }
}

