/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config;

import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class SyncedConfigFile
extends ConfigFile {
    private boolean loadedSyncData = false;

    @Override
    public boolean isServerOnly() {
        return true;
    }

    public static void playerJoined(ServerPlayer player) {
        for (ConfigFile file : SyncedConfigFile.getAvailableFiles()) {
            if (!(file instanceof SyncedConfigFile)) continue;
            SyncedConfigFile f = (SyncedConfigFile)file;
            f.sendSyncPacket((Player)player);
        }
    }

    public static void onClientLeavesServer() {
        for (ConfigFile file : SyncedConfigFile.getAvailableFiles()) {
            if (!(file instanceof SyncedConfigFile)) continue;
            file.clearSyncedData();
        }
    }

    protected SyncedConfigFile(String fileName, ResourceLocation id) {
        super(id, fileName, ConfigFile.LoadPhase.GAME_START);
    }

    @Override
    public boolean isLoaded() {
        return super.isLoaded() || this.loadedSyncData;
    }

    @Override
    public void loadSyncData(Map<String, String> syncData) {
        super.loadSyncData(syncData);
        this.loadedSyncData = true;
    }

    @Override
    public void clearSyncedData() {
        super.clearSyncedData();
        this.loadedSyncData = false;
    }

    @Override
    protected void afterReload() {
        this.sendSyncPacket(null);
    }

    @Override
    protected void afterOptionChanged(ConfigOption<?> option) {
        this.sendSyncPacket(null);
    }
}

