/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.icons;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.GsonHelper;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TextIcon
extends IconData {
    public static final IconData.Type TYPE = new IconData.Type(VersionUtil.lcResource("text"), TextIcon::loadText, TextIcon::parseText);
    private final Component iconText;
    private final int textColor;

    private TextIcon(Component iconText, int textColor) {
        super(TYPE);
        this.iconText = iconText;
        this.textColor = textColor;
    }

    public static IconData ofText(Component text) {
        return TextIcon.ofText(text, 0xFFFFFF);
    }

    public static IconData ofText(Component text, int textColor) {
        return new TextIcon(text, textColor);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(EasyGuiGraphics gui, int x, int y) {
        int xPos = x + 8 - gui.font.width((FormattedText)this.iconText) / 2;
        Objects.requireNonNull(gui.font);
        int yPos = y + (16 - 9) / 2;
        gui.drawShadowed(this.iconText, xPos, yPos, this.textColor);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        tag.putString("Text", Component.Serializer.toJson((Component)this.iconText, (HolderLookup.Provider)lookup));
        tag.putInt("Color", this.textColor);
    }

    @Override
    protected void writeAdditional(JsonObject json, HolderLookup.Provider lookup) {
        json.add("Text", (JsonElement)ComponentSerialization.CODEC.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)lookup), (Object)this.iconText).getOrThrow());
        json.addProperty("Color", (Number)this.textColor);
    }

    private static IconData loadText(CompoundTag tag, HolderLookup.Provider lookup) {
        MutableComponent text = Component.Serializer.fromJson((String)tag.getString("Text"), (HolderLookup.Provider)lookup);
        int color = tag.getInt("Color");
        return new TextIcon((Component)text, color);
    }

    private static IconData parseText(JsonObject json, HolderLookup.Provider lookup) {
        Component text = (Component)((Pair)ComponentSerialization.CODEC.decode((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)lookup), (Object)json.get("Text")).getOrThrow(JsonSyntaxException::new)).getFirst();
        int color = GsonHelper.getAsInt((JsonObject)json, (String)"Color", (int)0x404040);
        return new TextIcon(text, color);
    }
}

