/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.taxes.reference.builtin;

import io.github.lightman314.lightmanscurrency.api.taxes.ITaxable;
import io.github.lightman314.lightmanscurrency.api.taxes.reference.TaxReferenceType;
import io.github.lightman314.lightmanscurrency.api.taxes.reference.TaxableReference;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public class TaxableTraderReference
extends TaxableReference {
    public static final TaxReferenceType TYPE = new TraderType();
    private final long traderID;

    public TaxableTraderReference(long traderID) {
        super(TYPE);
        this.traderID = traderID;
    }

    @Override
    @Nullable
    public ITaxable getTaxable(boolean isClient) {
        return TraderAPI.getApi().GetTrader(isClient, this.traderID);
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag tag) {
        tag.putLong("TraderID", this.traderID);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean matches(@Nonnull TaxableReference otherReference) {
        if (!(otherReference instanceof TaxableTraderReference)) return false;
        TaxableTraderReference ttr = (TaxableTraderReference)otherReference;
        if (ttr.traderID != this.traderID) return false;
        return true;
    }

    private static class TraderType
    extends TaxReferenceType {
        private TraderType() {
            super(VersionUtil.lcResource("trader"));
        }

        @Override
        public TaxableReference load(CompoundTag tag) {
            return new TaxableTraderReference(tag.getLong("TraderID"));
        }
    }
}

