/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders.blocks;

import io.github.lightman314.lightmanscurrency.api.misc.blocks.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IWideBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.LazyShapes;
import io.github.lightman314.lightmanscurrency.api.traders.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.api.traders.blocks.TraderBlockTallRotatable;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.TriFunction;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class TraderBlockTallWideRotatable
extends TraderBlockTallRotatable
implements IWideBlock {
    private final TriFunction<Direction, Boolean, Boolean, VoxelShape> shape;

    protected TraderBlockTallWideRotatable(BlockBehaviour.Properties properties) {
        this(properties, LazyShapes.TALL_WIDE_BOX_SHAPE);
    }

    protected TraderBlockTallWideRotatable(BlockBehaviour.Properties properties, VoxelShape north, VoxelShape east, VoxelShape south, VoxelShape west) {
        this(properties, LazyShapes.lazyTallWideDirectionalShape(north, east, south, west));
    }

    protected TraderBlockTallWideRotatable(BlockBehaviour.Properties properties, BiFunction<Direction, Boolean, VoxelShape> tallShape) {
        this(properties, LazyShapes.lazyTallWideDirectionalShape(tallShape));
    }

    protected TraderBlockTallWideRotatable(BlockBehaviour.Properties properties, TriFunction<Direction, Boolean, Boolean, VoxelShape> shape) {
        super(properties);
        this.shape = shape;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)ISBOTTOM, (Comparable)Boolean.valueOf(true))).setValue((Property)ISLEFT, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected boolean shouldMakeTrader(BlockState state) {
        return this.getIsBottom(state) && this.getIsLeft(state);
    }

    @Override
    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return this.shape.apply(this.getFacing(state), this.getIsBottom(state), this.getIsLeft(state));
    }

    @Override
    protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ISLEFT});
    }

    @Override
    public BlockState getStateForPlacement(@Nonnull BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)ISLEFT, (Comparable)Boolean.valueOf(true));
    }

    @Override
    public void setPlacedBy(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, LivingEntity player, @Nonnull ItemStack stack) {
        BlockPos rightPos = IRotatableBlock.getRightPos(pos, this.getFacing(state));
        if (this.isReplaceable(level, rightPos) && this.isReplaceable(level, rightPos.above()) && this.isReplaceable(level, pos.above())) {
            level.setBlockAndUpdate(pos.above(), (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ISBOTTOM, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)ISLEFT, (Comparable)Boolean.valueOf(true)));
            level.setBlockAndUpdate(rightPos, (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ISBOTTOM, (Comparable)Boolean.valueOf(true))).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)ISLEFT, (Comparable)Boolean.valueOf(false)));
            level.setBlockAndUpdate(rightPos.above(), (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ISBOTTOM, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)ISLEFT, (Comparable)Boolean.valueOf(false)));
        } else {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof TraderBlockEntity) {
                TraderBlockEntity be = (TraderBlockEntity)blockEntity;
                be.flagAsLegitBreak();
            }
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 35);
            if (player instanceof Player) {
                Player p = (Player)player;
                ItemStack giveStack = stack.copy();
                giveStack.setCount(1);
                InventoryUtil.safeGiveToPlayer(p.getInventory(), giveStack);
            }
        }
        this.setPlacedByBase(level, pos, state, player, stack);
    }

    @Override
    @Nonnull
    public BlockState playerWillDestroy(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        TraderBlockEntity trader;
        this.playerWillDestroyBase(level, pos, state, player);
        BlockEntity blockEntity = this.getBlockEntity(state, (LevelAccessor)level, pos);
        if (blockEntity instanceof TraderBlockEntity && !(trader = (TraderBlockEntity)blockEntity).canBreak(player)) {
            return state;
        }
        if (this.getIsBottom(state)) {
            this.setAir(level, pos.above(), player);
            otherPos = this.getOtherSide(pos, state);
            this.setAir(level, otherPos, player);
            this.setAir(level, otherPos.above(), player);
        } else {
            this.setAir(level, pos.below(), player);
            otherPos = this.getOtherSide(pos, state);
            this.setAir(level, otherPos, player);
            this.setAir(level, otherPos.below(), player);
        }
        return state;
    }

    @Override
    public void removeOtherBlocks(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockPos pos) {
        BlockPos otherPos = this.getOtherSide(pos, state);
        this.setAir(level, this.getOtherHeight(pos, state), null);
        this.setAir(level, otherPos, null);
        this.setAir(level, this.getOtherHeight(otherPos, state), null);
    }
}

