/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCTags;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.SyncedConfigFile;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IOwnableBlock;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.SpriteUtil;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.ChainData;
import io.github.lightman314.lightmanscurrency.api.variants.VariantProvider;
import io.github.lightman314.lightmanscurrency.api.variants.item.IVariantItem;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.WalletScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.ChestCoinCollectButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.EjectionMenuButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.NotificationButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.TeamManagerButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.wallet.VisibilityToggleButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.wallet.WalletButton;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.ModelVariantDataManager;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.data.ModelVariant;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.VariantProperties;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.builtin.TooltipInfo;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.attachments.WalletHandler;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.common.core.ModSounds;
import io.github.lightman314.lightmanscurrency.common.enchantments.MoneyMendingEnchantment;
import io.github.lightman314.lightmanscurrency.common.items.PortableATMItem;
import io.github.lightman314.lightmanscurrency.common.items.PortableTerminalItem;
import io.github.lightman314.lightmanscurrency.common.items.TooltipItem;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.ItemValidator;
import io.github.lightman314.lightmanscurrency.common.text.TextEntry;
import io.github.lightman314.lightmanscurrency.integration.curios.LCCurios;
import io.github.lightman314.lightmanscurrency.network.message.bank.CPacketOpenATM;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketOpenNetworkTerminal;
import io.github.lightman314.lightmanscurrency.network.message.wallet.CPacketOpenWallet;
import io.github.lightman314.lightmanscurrency.network.message.walletslot.CPacketSetVisible;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ContainerScreenEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(modid="lightmanscurrency", value={Dist.CLIENT})
public class ClientEvents {
    public static final KeyMapping KEY_WALLET = new KeyMapping(LCText.KEY_WALLET.getKey(), 86, "key.categories.inventory");
    public static final KeyMapping KEY_PORTABLE_TERMINAL = new KeyMapping(LCText.KEY_PORTABLE_TERMINAL.getKey(), 92, "key.categories.inventory");
    public static final KeyMapping KEY_PORTABLE_ATM = new KeyMapping(LCText.KEY_PORTABLE_ATM.getKey(), 61, "key.categories.inventory");

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.screen instanceof WalletScreen && minecraft.player != null) {
            if (event.getAction() == 1 && event.getKey() == KEY_WALLET.getKey().getValue()) {
                minecraft.player.clientSideCloseContainer();
            }
        } else if (minecraft.player != null && minecraft.screen == null) {
            LocalPlayer player = minecraft.player;
            if (KEY_WALLET.isDown()) {
                new CPacketOpenWallet(-1).send();
                ItemStack wallet = CoinAPI.getApi().getEquippedWallet((Player)player);
                if (!wallet.isEmpty()) {
                    minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value()), (float)(1.25f + player.level().random.nextFloat() * 0.5f), (float)0.75f));
                    if (!WalletItem.isEmpty(wallet)) {
                        minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)ModSounds.COINS_CLINKING.get(), (float)1.0f, (float)0.4f));
                    }
                }
            }
            if (LCCurios.isLoaded() && event.getAction() == 1) {
                Item atm;
                Item terminal;
                boolean fail = true;
                if (event.getKey() == KEY_PORTABLE_TERMINAL.getKey().getValue() && (terminal = LCCurios.lookupPortableTerminal((LivingEntity)minecraft.player)) != null) {
                    new CPacketOpenNetworkTerminal(new ItemValidator((ItemLike)terminal)).send();
                    fail = false;
                }
                if (fail && event.getKey() == KEY_PORTABLE_ATM.getKey().getValue() && (atm = LCCurios.lookupPortableATM((LivingEntity)minecraft.player)) != null) {
                    new CPacketOpenATM(atm).send();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onInventoryGuiInit(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof InventoryScreen || screen instanceof CreativeModeInventoryScreen) {
            AbstractContainerScreen gui = (AbstractContainerScreen)screen;
            event.addListener((GuiEventListener)new NotificationButton(gui));
            event.addListener((GuiEventListener)new TeamManagerButton(gui));
            event.addListener((GuiEventListener)new EjectionMenuButton(gui));
            Minecraft mc = Minecraft.getInstance();
            if (LCCurios.isLoaded()) {
                return;
            }
            event.addListener((GuiEventListener)new WalletButton(gui, CPacketOpenWallet::sendEquippedPacket));
            event.addListener((GuiEventListener)new VisibilityToggleButton(gui, ClientEvents::toggleVisibility));
        } else if (screen instanceof ContainerScreen) {
            ContainerScreen chestScreen = (ContainerScreen)screen;
            event.addListener((GuiEventListener)ChestCoinCollectButton.chestBuilder().screen(chestScreen).build());
        }
    }

    private static void toggleVisibility() {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        WalletHandler handler = WalletHandler.get((LivingEntity)player);
        boolean nowVisible = !handler.visible();
        handler.setVisible(nowVisible);
        new CPacketSetVisible(nowVisible).send();
    }

    @SubscribeEvent
    public static void renderInventoryScreen(ContainerScreenEvent.Render.Background event) {
        if (LCCurios.isLoaded()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        AbstractContainerScreen screen = event.getContainerScreen();
        if (screen instanceof InventoryScreen || screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen creativeScreen;
            if (screen instanceof CreativeModeInventoryScreen && !(creativeScreen = (CreativeModeInventoryScreen)screen).isInventoryOpen()) {
                return;
            }
            EasyGuiGraphics gui = EasyGuiGraphics.create((ContainerScreenEvent.Render)event);
            ScreenPosition slotPosition = ClientEvents.getWalletSlotPosition(screen instanceof CreativeModeInventoryScreen).offsetScreen(screen);
            gui.resetColor();
            SpriteUtil.EMPTY_SLOT_NORMAL.render(gui, slotPosition.x, slotPosition.y);
        }
    }

    @SubscribeEvent
    public static void renderInventoryTooltips(ScreenEvent.Render.Post event) {
        if (event.getScreen() instanceof InventoryScreen || event.getScreen() instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen creativeScreen;
            AbstractContainerScreen screen = (AbstractContainerScreen)event.getScreen();
            if (!screen.getMenu().getCarried().isEmpty()) {
                return;
            }
            if (screen instanceof CreativeModeInventoryScreen && !(creativeScreen = (CreativeModeInventoryScreen)screen).isInventoryOpen()) {
                return;
            }
            EasyGuiGraphics gui = EasyGuiGraphics.create((ScreenEvent.Render)event);
            NotificationButton.tryRenderTooltip(gui);
            TeamManagerButton.tryRenderTooltip(gui);
            EjectionMenuButton.tryRenderTooltip(gui);
        } else if (event.getScreen() instanceof ContainerScreen) {
            ChestCoinCollectButton.tryRenderTooltip(EasyGuiGraphics.create((ScreenEvent.Render)event), event.getMouseX(), event.getMouseY());
        }
    }

    public static ScreenPosition getWalletSlotPosition(boolean isCreative) {
        return isCreative ? (ScreenPosition)LCConfig.CLIENT.walletSlotCreative.get() : (ScreenPosition)LCConfig.CLIENT.walletSlot.get();
    }

    @SubscribeEvent
    public static void playerJoinsServer(ClientPlayerNetworkEvent.LoggingIn event) {
        ConfigFile.loadClientFiles(ConfigFile.LoadPhase.GAME_START);
    }

    @SubscribeEvent
    public static void playerLeavesServer(ClientPlayerNetworkEvent.LoggingOut event) {
        SyncedConfigFile.onClientLeavesServer();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onItemTooltip(ItemTooltipEvent event) {
        IVariantItem vi;
        BlockItem bi;
        Block b;
        Item item;
        if (event.getEntity() == null || CoinAPI.getApi().NoDataAvailable() || event.getContext().registries() == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (CoinAPI.getApi().IsCoin(stack, true)) {
            ChainData.addCoinTooltips(event.getItemStack(), event.getToolTip(), event.getFlags(), event.getEntity());
        }
        MoneyMendingEnchantment.addEnchantmentTooltips(stack, event.getToolTip(), event.getContext());
        if (LCConfig.SERVER.isLoaded() && ((Boolean)LCConfig.SERVER.anarchyMode.get()).booleanValue() && (item = stack.getItem()) instanceof BlockItem && (b = (bi = (BlockItem)item).getBlock()) instanceof IOwnableBlock) {
            TooltipItem.insertTooltip((List<Component>)event.getToolTip(), (Component)LCText.TOOLTIP_ANARCHY_WARNING.get(new Object[0]).withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.RED));
        }
        TooltipItem.insertTooltip(stack, ModDataComponents.TRADER_ITEM_DATA, event.getContext(), event.getFlags(), event.getToolTip());
        if (stack.getItem() instanceof WalletItem) {
            ClientEvents.appendKeyBindTooltip(event, LCText.TOOLTIP_WALLET_KEY_BIND, KEY_WALLET);
        }
        if (LCCurios.isLoaded()) {
            if (stack.getItem() instanceof PortableTerminalItem) {
                ClientEvents.appendKeyBindTooltip(event, LCText.TOOLTIP_TERMINAL_KEY_BIND, KEY_PORTABLE_TERMINAL);
            }
            if (stack.getItem() instanceof PortableATMItem) {
                ClientEvents.appendKeyBindTooltip(event, LCText.TOOLTIP_ATM_KEY_BIND, KEY_PORTABLE_ATM);
            }
        }
        if ((vi = VariantProvider.getVariantItem(stack)) != null) {
            ClientEvents.appendVariantTooltip(event, stack, vi, event.getFlags());
        }
        if (InventoryUtil.ItemHasTag(stack, LCTags.Items.VARIANT_WANDS)) {
            TooltipItem.insertTooltip((List<Component>)event.getToolTip(), LCText.TOOLTIP_VARIANT_WAND);
        }
    }

    private static void appendVariantTooltip(ItemTooltipEvent event, ItemStack stack, IVariantItem item, TooltipFlag flag) {
        Consumer<Component> adder = ClientEvents.createInjection(event);
        if (stack.has(ModDataComponents.MODEL_VARIANT)) {
            ResourceLocation variantID = (ResourceLocation)stack.get(ModDataComponents.MODEL_VARIANT);
            ModelVariant variant = ModelVariantDataManager.getVariant(variantID);
            boolean insertIndex = true;
            if (variant != null) {
                adder.accept((Component)LCText.TOOLTIP_MODEL_VARIANT_NAME.get(variant.getName().withStyle(ChatFormatting.GOLD)).withStyle(ChatFormatting.YELLOW));
                if (variant.has(VariantProperties.TOOLTIP_INFO)) {
                    TooltipInfo extraTooltip = variant.get(VariantProperties.TOOLTIP_INFO);
                    if (extraTooltip.drawOnItem) {
                        for (Component l : extraTooltip.getTooltip()) {
                            adder.accept(l);
                        }
                    }
                }
            }
            if (flag.isAdvanced()) {
                adder.accept((Component)LCText.TOOLTIP_MODEL_VARIANT_ID.get(variantID.toString()).withStyle(ChatFormatting.DARK_GRAY));
            }
        }
        if (stack.has(ModDataComponents.VARIANT_LOCK)) {
            adder.accept((Component)LCText.TOOLTIP_MODEL_VARIANT_LOCKED.getWithStyle(ChatFormatting.GRAY));
        }
    }

    private static Consumer<Component> createInjection(ItemTooltipEvent event) {
        return ClientEvents.createInjection(event.getToolTip());
    }

    private static Consumer<Component> createInjection(List<Component> tooltip) {
        if (tooltip.isEmpty()) {
            return tooltip::add;
        }
        for (int i = 0; i < tooltip.size(); ++i) {
            Component line = tooltip.get(i);
            TextColor color = line.getStyle().getColor();
            if (color == null || color.getValue() != ChatFormatting.DARK_GRAY.getColor().intValue()) continue;
            return new TooltipInjector(tooltip, i);
        }
        return tooltip::add;
    }

    private static void appendKeyBindTooltip(@Nonnull ItemTooltipEvent event, @Nonnull TextEntry tooltip, @Nonnull KeyMapping key) {
        event.getToolTip().add(1, tooltip.get(EasyText.makeMutable(key.getTranslatedKeyMessage()).withStyle(ChatFormatting.YELLOW)));
    }

    private static class TooltipInjector
    implements Consumer<Component> {
        private final List<Component> tooltips;
        private int injectIndex;

        TooltipInjector(List<Component> tooltips, int injectIndex) {
            this.tooltips = tooltips;
            this.injectIndex = injectIndex;
        }

        @Override
        public void accept(Component component) {
            this.tooltips.add(this.injectIndex++, component);
        }
    }
}

