/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.easy.tabbed;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyMenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.easy.tabbed.EasyMenuClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.easy.tabbed.IEasyTabbedMenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.util.IWidgetPositioner;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.tab.ITab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.tab.TabButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.menus.tabbed.EasyMenuTab;
import io.github.lightman314.lightmanscurrency.common.menus.tabbed.EasyTabbedMenu;
import io.github.lightman314.lightmanscurrency.common.menus.tabbed.IEasyTabbedMenu;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public abstract class AdvancedTabbedMenuScreen<X extends IEasyTabbedMenu<T>, M extends EasyTabbedMenu<X, T>, T extends EasyMenuTab<X, T>, S extends IEasyTabbedMenuScreen<X, T, S>>
extends EasyMenuScreen<M>
implements IEasyTabbedMenuScreen<X, T, S> {
    private int currentTabIndex = 0;
    private final Map<Integer, EasyMenuClientTab<? extends T, X, T, S, ?>> clientTabs = new HashMap();

    @Override
    public final int getCurrentTabIndex() {
        return this.currentTabIndex;
    }

    public final EasyMenuClientTab<? extends T, X, T, S, ?> currentTab() {
        return this.clientTabs.get(this.currentTabIndex);
    }

    @Override
    @Nonnull
    public final X getMenuInterface() {
        return (X)((IEasyTabbedMenu)this.menu);
    }

    public AdvancedTabbedMenuScreen(@Nonnull M menu, @Nonnull Inventory inventory) {
        this(menu, inventory, (Component)EasyText.empty());
    }

    public AdvancedTabbedMenuScreen(@Nonnull M menu, @Nonnull Inventory inventory, @Nonnull Component title) {
        super(menu, inventory, title);
        ((EasyTabbedMenu)this.menu).setScreen(this);
        ((EasyTabbedMenu)this.menu).setMessageListener(this::HandleClientMessage);
        ((EasyTabbedMenu)this.menu).getAllTabs().forEach((key, tab) -> {
            Object ct = tab.createClientTab(this);
            try {
                this.clientTabs.put((Integer)key, (EasyMenuClientTab)Objects.requireNonNull(ct, "Tab at slot " + key + " returned a null client tab!"));
                LightmansCurrency.LogDebug("Created client tab for slot " + key);
            }
            catch (ClassCastException e) {
                throw new IllegalStateException("Tab at slot " + key + " did not return a valid client tab!", e);
            }
        });
    }

    @Override
    protected final void initialize(ScreenArea screenArea) {
        this.init(screenArea);
        IWidgetPositioner tabButtonPositioner = this.getTabButtonPositioner();
        tabButtonPositioner.clear();
        this.addChild(tabButtonPositioner);
        ArrayList<Pair> buttons = new ArrayList<Pair>();
        this.clientTabs.forEach((key, tab) -> {
            TabButton button = ((TabButton.Builder)((TabButton.Builder)((TabButton.Builder)TabButton.builder().pressAction(() -> this.ChangeTab((int)key))).tab((ITab)tab).addon(EasyAddonHelper.activeCheck(() -> this.currentTabIndex != key))).addon(EasyAddonHelper.visibleCheck(() -> tab.tabVisible() && ((EasyMenuTab)tab.commonTab).canOpen(((EasyTabbedMenu)this.menu).player)))).build();
            this.addChild(button);
            buttons.add(Pair.of((Object)key, (Object)button));
        });
        buttons.sort(Comparator.comparingInt(Pair::getFirst));
        for (Pair buttonPair : buttons) {
            tabButtonPositioner.addWidget((EasyWidget)((Object)buttonPair.getSecond()));
        }
        this.currentTab().onOpen();
    }

    @Nonnull
    protected abstract IWidgetPositioner getTabButtonPositioner();

    protected abstract void init(ScreenArea var1);

    @Override
    public final void ChangeTab(int newTab) {
        this.ChangeTab(newTab, null);
    }

    @Override
    public final void ChangeTab(int newTab, @Nullable LazyPacketData.Builder data) {
        this.ChangeTab(newTab, data == null ? null : data.build(), true);
    }

    @Override
    public final void ChangeTab(int newTab, @Nullable LazyPacketData data, boolean sendPacket) {
        if (newTab == this.currentTabIndex) {
            return;
        }
        if (!this.clientTabs.containsKey(newTab)) {
            LightmansCurrency.LogError("Attempted to open tab " + newTab + " on the client, but no tab with that key is present in the menu!");
            return;
        }
        this.currentTab().onClose();
        this.currentTabIndex = newTab;
        if (data != null && data.size("ChangeTab") > 0) {
            this.currentTab().OpenMessage(data);
        }
        this.currentTab().onOpen();
        LightmansCurrency.LogDebug("Client Tab Changed to " + this.currentTabIndex);
        if (sendPacket) {
            ((EasyTabbedMenu)this.menu).ChangeTab(newTab, data);
        }
    }

    @Override
    protected final void renderBG(@Nonnull EasyGuiGraphics gui) {
        this.renderBackground(gui);
        this.currentTab().renderBG(gui);
    }

    protected abstract void renderBackground(@Nonnull EasyGuiGraphics var1);

    @Override
    protected final void renderAfterWidgets(@Nonnull EasyGuiGraphics gui) {
        this.renderLate(gui);
        this.currentTab().renderAfterWidgets(gui);
    }

    protected void renderLate(@Nonnull EasyGuiGraphics gui) {
    }

    protected final void HandleClientMessage(@Nonnull LazyPacketData message) {
        if (message.contains("ChangeTab")) {
            this.ChangeTab(message.getInt("ChangeTab"), message, false);
        }
    }

    @Override
    public boolean blockInventoryClosing() {
        return this.currentTab() != null && this.currentTab().blockInventoryClosing();
    }

    @Override
    @Nullable
    public Pair<ItemStack, ScreenArea> getHoveredItem(@Nonnull ScreenPosition mousePos) {
        EasyMenuClientTab<T, X, T, S, ?> tab = this.currentTab();
        if (tab != null) {
            return tab.getHoveredItem(mousePos);
        }
        return super.getHoveredItem(mousePos);
    }

    @Override
    @Nullable
    public Pair<FluidStack, ScreenArea> getHoveredFluid(@Nonnull ScreenPosition mousePos) {
        EasyMenuClientTab<T, X, T, S, ?> tab = this.currentTab();
        if (tab != null) {
            return tab.getHoveredFluid(mousePos);
        }
        return super.getHoveredFluid(mousePos);
    }
}

