/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.capability.money.IMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.QuarantineAPI;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.money.bank.menu.IBankAccountAdvancedMenu;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.builtin.PlayerBankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.salary.SalaryData;
import io.github.lightman314.lightmanscurrency.api.money.coins.atm.ATMAPI;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.common.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.data.types.BankDataCache;
import io.github.lightman314.lightmanscurrency.common.menus.LazyMessageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.slots.CoinSlot;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidator;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ATMMenu
extends LazyMessageMenu
implements IBankAccountAdvancedMenu {
    private final SimpleContainer coinInput = new SimpleContainer(9);
    private final IMoneyHandler moneyHandler = MoneyAPI.getApi().GetATMMoneyHandler(this.player, (Container)this.coinInput);
    private final List<CoinSlot> coinSlots;
    private Component transferMessage = null;

    @Override
    public Player getPlayer() {
        return this.player;
    }

    public SimpleContainer getCoinInput() {
        return this.coinInput;
    }

    public IMoneyHandler getMoneyHandler() {
        return this.moneyHandler;
    }

    public List<CoinSlot> getCoinSlots() {
        return this.coinSlots;
    }

    public ATMMenu(int windowId, Inventory inventory, MenuValidator validator) {
        super(ModMenus.ATM.get(), windowId, inventory, validator);
        int x;
        this.addValidator(() -> !QuarantineAPI.IsDimensionQuarantined((Entity)this.player));
        ArrayList<CoinSlot> temp = new ArrayList<CoinSlot>();
        for (x = 0; x < this.coinInput.getContainerSize(); ++x) {
            CoinSlot slot = new CoinSlot((Container)this.coinInput, x, 8 + x * 18, 129, false);
            this.addSlot(slot);
            temp.add(slot);
        }
        this.coinSlots = ImmutableList.copyOf(temp);
        for (int y = 0; y < 3; ++y) {
            for (int x2 = 0; x2 < 9; ++x2) {
                this.addSlot(new Slot((Container)inventory, x2 + y * 9 + 9, 8 + x2 * 18, 161 + y * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)inventory, x, 8 + x * 18, 219));
        }
    }

    @Override
    protected void onValidationTick(@Nonnull Player player) {
        this.getBankAccountReference();
    }

    public void removed(@Nonnull Player player) {
        BankDataCache data;
        BankReference account;
        super.removed(player);
        this.clearContainer(player, (Container)this.coinInput);
        if (!this.isClient() && !(account = this.getBankAccountReference()).canPersist(player) && (data = BankDataCache.TYPE.get(this.isClient())) != null) {
            data.setSelectedAccount(this.player, PlayerBankReference.of(this.player));
        }
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player player, int index) {
        ItemStack clickedStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            clickedStack = slotStack.copy();
            if (index < this.coinInput.getContainerSize() ? !this.moveItemStackTo(slotStack, this.coinInput.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(slotStack, 0, this.coinInput.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return clickedStack;
    }

    public void SendCoinExchangeMessage(String command) {
        this.SendMessageToServer(this.builder().setString("ExchangeCoinCommand", command));
    }

    public void ExchangeCoins(String command) {
        ATMAPI.ExecuteATMExchangeCommand((Container)this.coinInput, command);
    }

    public MutableComponent SetPlayerAccount(String playerName) {
        if (LCAdminMode.isAdminPlayer(this.player)) {
            PlayerReference accountPlayer = PlayerReference.of(false, playerName);
            if (accountPlayer != null) {
                BankDataCache data = BankDataCache.TYPE.get(this.isClient());
                if (data != null) {
                    data.setSelectedAccount(this.player, PlayerBankReference.of(accountPlayer));
                }
                return LCText.GUI_BANK_SELECT_PLAYER_SUCCESS.get(accountPlayer.getName(false));
            }
            return LCText.GUI_BANK_TRANSFER_ERROR_NULL_TARGET.get(new Object[0]);
        }
        return EasyText.literal("ERROR");
    }

    public boolean hasTransferMessage() {
        return this.transferMessage != null;
    }

    public Component getTransferMessage() {
        return this.transferMessage;
    }

    @Override
    public void setTransferMessage(Component message) {
        this.transferMessage = message;
    }

    public void clearMessage() {
        this.transferMessage = null;
    }

    public void SetNotificationValueAndUpdate(@Nonnull String type, @Nonnull MoneyValue newValue) {
        IBankAccount ba = this.getBankAccount();
        if (ba != null) {
            ba.setNotificationLevel(type, newValue);
        }
        this.SendMessageToServer(this.builder().setString("NotificationValueType", type).setMoneyValue("NotificationValueChange", newValue));
    }

    @Override
    public void HandleMessage(@Nonnull LazyPacketData message) {
        IBankAccount ba;
        if (message.contains("ExchangeCoinCommand")) {
            this.ExchangeCoins(message.getString("ExchangeCoinCommand"));
        }
        if (message.contains("NotificationValueChange") && (ba = this.getBankAccount()) != null) {
            ba.setNotificationLevel(message.getString("NotificationValueType"), message.getMoneyValue("NotificationValueChange"));
        }
        if (message.contains("ResetCards") && (ba = this.getBankAccount()) != null) {
            ba.resetCards();
        }
        if (message.contains("CreateSalaryOption")) {
            ba = this.getBankAccount();
            if (this.canEditSalaries() && ba instanceof BankAccount) {
                BankAccount account = (BankAccount)ba;
                account.createNewSalary();
                int newSelection = account.getSalaries().size() - 1;
                this.SendMessageToClient(this.builder().setInt("SelectSalary", newSelection));
                LightmansCurrency.LogDebug("Created Salary on the server!\n" + account.getName().getString() + " now has " + account.getSalaries().size() + " Salaries!");
            } else {
                LightmansCurrency.LogDebug("Failed to create salary on the server!");
            }
        }
        if (message.contains("EditSalary") && (ba = this.getBankAccount()) != null && this.canEditSalaries()) {
            int salaryIndex = message.getInt("EditSalary");
            List<SalaryData> data = ba.getSalaries();
            if (salaryIndex >= 0 && salaryIndex < data.size()) {
                data.get(salaryIndex).HandleEditMessage(this.player, message);
            }
        }
    }

    private boolean canEditSalaries() {
        BankReference br = this.getBankAccountReference();
        if (br == null) {
            return false;
        }
        return br.salaryPermission(this.player) >= 2;
    }
}

