/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral;

import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import io.github.lightman314.lightmanscurrency.api.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.api.events.TraderEvent;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.integration.computercraft.LCComputerHelper;
import io.github.lightman314.lightmanscurrency.integration.computercraft.LCPeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.data.LCLuaTable;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.MultiTraderPeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.TraderPeripheral;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.common.NeoForge;

public class TerminalPeripheral
extends MultiTraderPeripheral {
    public static final TerminalPeripheral INSTANCE = new TerminalPeripheral();
    private final Consumer<TradeEvent.PreTradeEvent> preTradeEventListener = this::preTradeEvent;
    private final Consumer<TradeEvent.PostTradeEvent> postTradeEventListener = this::postTradeEvent;
    private final Consumer<TraderEvent.CreateNetworkTraderEvent> newTraderEventListener = this::newTraderEvent;
    private final Consumer<TraderEvent.RemoveNetworkTraderEvent> removedTraderEventListener = this::removeTraderEvent;

    private TerminalPeripheral() {
    }

    public String getType() {
        return "lc_terminal";
    }

    @Override
    protected void onFirstAttachment() {
        super.onFirstAttachment();
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, this.preTradeEventListener);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, this.postTradeEventListener);
    }

    @Override
    protected void onLastDetachment() {
        NeoForge.EVENT_BUS.unregister(this.preTradeEventListener);
        NeoForge.EVENT_BUS.unregister(this.postTradeEventListener);
    }

    @Override
    @Nonnull
    protected List<TraderData> getAccessibleTraders() {
        return TraderAPI.getApi().GetAllNetworkTraders(false);
    }

    @Override
    protected boolean stillAccessible(TraderData trader) {
        return trader.showOnTerminal();
    }

    @Override
    public boolean equals(@Nullable IPeripheral peripheral) {
        return peripheral == INSTANCE;
    }

    private void preTradeEvent(TradeEvent.PreTradeEvent event) {
        LCPeripheral lCPeripheral;
        TraderData t = event.getTrader();
        if (t.canShowOnTerminal() && (lCPeripheral = LCComputerHelper.getPeripheral(t)) instanceof TraderPeripheral) {
            TraderPeripheral trader = (TraderPeripheral)lCPeripheral;
            LCPeripheral tradeWrapper = trader.safeWrapTrade(event.getTrade());
            if (tradeWrapper == null) {
                return;
            }
            LCLuaTable player = LCLuaTable.fromPlayer(event.getPlayerReference());
            boolean canceled = event.isCanceled();
            this.queueEvent("lc_trade_pre", (IComputerAccess computer) -> new Object[]{trader.asTable((IComputerAccess)computer), event.getTradeIndex(), tradeWrapper.asTable((IComputerAccess)computer), player, canceled});
        }
    }

    private void postTradeEvent(TradeEvent.PostTradeEvent event) {
        LCPeripheral lCPeripheral;
        TraderData t = event.getTrader();
        if (t.canShowOnTerminal() && (lCPeripheral = LCComputerHelper.getPeripheral(t)) instanceof TraderPeripheral) {
            TraderPeripheral trader = (TraderPeripheral)lCPeripheral;
            LCPeripheral tradeWrapper = trader.safeWrapTrade(event.getTrade());
            if (tradeWrapper == null) {
                return;
            }
            LCLuaTable player = LCLuaTable.fromPlayer(event.getPlayerReference());
            LCLuaTable finalPrice = LCLuaTable.fromMoney(event.getPricePaid());
            LCLuaTable taxesPaid = LCLuaTable.fromMoney(event.getTaxesPaid());
            this.queueEvent("lc_trade", (IComputerAccess computer) -> new Object[]{trader.asTable((IComputerAccess)computer), event.getTradeIndex(), tradeWrapper.asTable((IComputerAccess)computer), player, finalPrice, taxesPaid});
        }
    }

    private void newTraderEvent(TraderEvent.CreateNetworkTraderEvent event) {
        LCPeripheral trader = LCComputerHelper.getPeripheral(event.getTrader());
        LCLuaTable player = LCLuaTable.fromPlayer(event.getPlayer());
        this.queueEvent("lc_trader_created", (IComputerAccess computer) -> new Object[]{trader.asTable((IComputerAccess)computer), player, event.getID()});
    }

    private void removeTraderEvent(TraderEvent.RemoveNetworkTraderEvent event) {
        LCPeripheral trader = LCComputerHelper.getPeripheral(event.getTrader());
        this.queueEvent("lc_trader_removed", (IComputerAccess computer) -> new Object[]{trader.asTable((IComputerAccess)computer), event.getID()});
    }
}

