/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.create.attributes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.ChainData;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.integration.create.attributes.LCItemAttributes;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CoinAttributeType
implements ItemAttributeType {
    private static final CoinAttribute IS_COIN_ATTRIBUTE = new NormalCoinAttribute("");
    public static final MapCodec<CoinAttribute> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.BOOL.fieldOf("ancient").forGetter(CoinAttribute::isAncient), (App)Codec.STRING.fieldOf("chain").forGetter(CoinAttribute::getChain)).apply((Applicative)builder, CoinAttributeType::parse));
    public static final StreamCodec<RegistryFriendlyByteBuf, CoinAttribute> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, CoinAttribute::isAncient, (StreamCodec)ByteBufCodecs.STRING_UTF8, CoinAttribute::getChain, CoinAttributeType::parse);

    public ItemAttribute createAttribute() {
        return IS_COIN_ATTRIBUTE;
    }

    public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
        ChainData chain = CoinAPI.getApi().ChainDataOfCoin(stack);
        if (chain != null) {
            return List.of(IS_COIN_ATTRIBUTE, new NormalCoinAttribute(chain.chain));
        }
        if (stack.getItem() == ModItems.COIN_ANCIENT.get()) {
            return List.of(IS_COIN_ATTRIBUTE, AncientCoinAttribute.INSTANCE);
        }
        return List.of();
    }

    public MapCodec<? extends ItemAttribute> codec() {
        return CODEC;
    }

    public StreamCodec<? super RegistryFriendlyByteBuf, ? extends ItemAttribute> streamCodec() {
        return STREAM_CODEC;
    }

    public static CoinAttribute parse(boolean ancient, String chain) {
        if (ancient) {
            return AncientCoinAttribute.INSTANCE;
        }
        if (chain.isEmpty()) {
            return IS_COIN_ATTRIBUTE;
        }
        return new NormalCoinAttribute(chain);
    }

    public static abstract class CoinAttribute
    implements ItemAttribute {
        public boolean isAncient() {
            return false;
        }

        public abstract String getChain();
    }

    public static class NormalCoinAttribute
    extends CoinAttribute {
        private final String chain;

        public NormalCoinAttribute(String chain) {
            this.chain = chain;
        }

        @Override
        public String getChain() {
            return this.chain;
        }

        public boolean appliesTo(ItemStack stack, Level world) {
            ChainData data = CoinAPI.getApi().ChainDataOfCoin(stack);
            if (data == null) {
                return false;
            }
            if (this.isNullType()) {
                return stack.getItem() == ModItems.COIN_ANCIENT.get();
            }
            return data.chain.equals(this.chain);
        }

        public ItemAttributeType getType() {
            return LCItemAttributes.COIN_ATTRIBUTE.get();
        }

        private boolean isNullType() {
            return this.chain.isEmpty();
        }

        private Component getChainName() {
            ChainData data = CoinAPI.getApi().ChainData(this.chain);
            return data == null ? EasyText.literal(this.chain) : data.getDisplayName();
        }

        public String getTranslationKey() {
            return this.chain.isEmpty() ? "lightmanscurrency.coin.any" : "lightmanscurrency.coin.chain";
        }

        public Object[] getTranslationParameters() {
            Object[] objectArray;
            if (this.isNullType()) {
                objectArray = new Object[]{};
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.getChainName();
            }
            return objectArray;
        }
    }

    public static class AncientCoinAttribute
    extends CoinAttribute {
        public static final CoinAttribute INSTANCE = new AncientCoinAttribute();

        private AncientCoinAttribute() {
        }

        @Override
        public boolean isAncient() {
            return true;
        }

        @Override
        public String getChain() {
            return "";
        }

        public boolean appliesTo(ItemStack stack, Level world) {
            return stack.getItem() == ModItems.COIN_ANCIENT.get();
        }

        public ItemAttributeType getType() {
            return LCItemAttributes.COIN_ATTRIBUTE.get();
        }

        public String getTranslationKey() {
            return "lightmanscurrency.coin.chain";
        }

        public Object[] getTranslationParameters() {
            return new Object[]{LCText.ANCIENT_COIN_VALUE_NAME.get(new Object[0])};
        }
    }
}

