/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.client.screen.builtin.subscreens;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.ConfigScreen;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.options.ConfigFileOption;
import io.github.lightman314.lightmanscurrency.api.config.options.builtin.MoneyValueOption;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.SpriteUtil;
import io.github.lightman314.lightmanscurrency.api.money.input.MoneyValueWidget;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MoneyValueConfigScreen
extends ConfigScreen {
    private final ConfigFileOption file;
    private final MoneyValueOption option;
    private final Consumer<Object> changeHandler;
    private MoneyValueWidget valueWidget;

    public MoneyValueConfigScreen(Screen parentScreen, ConfigFileOption file, MoneyValueOption option, Consumer<Object> changeHandler) {
        super(parentScreen);
        this.file = file;
        this.option = option;
        this.changeHandler = changeHandler;
    }

    @Override
    protected void initialize(ScreenArea screenArea) {
        this.valueWidget = this.addChild(((MoneyValueWidget.Builder)((MoneyValueWidget.Builder)MoneyValueWidget.builder().position(screenArea.centerX() - 88, screenArea.centerY() - 34)).startingValue((MoneyValue)this.option.get()).allowFreeInputs(this.option.allowed.test(MoneyValue.free())).valueHandler(this::changeValue).addon(EasyAddonHelper.activeCheck(() -> this.file.canEdit(this.f_96541_)))).build());
        this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.centerX() - 100, screenArea.height - 25)).width(200)).text(LCText.CONFIG_BACK).pressAction(this::m_7379_)).build());
    }

    @Override
    protected void renderAdditionalBG(EasyGuiGraphics gui) {
        if (this.valueWidget != null) {
            SpriteUtil.GENERIC_BACKGROUND.render(gui, this.valueWidget.m_252754_() - 5, this.valueWidget.m_252907_() - 10, 186, 89);
        }
    }

    @Override
    protected List<Component> getTitleSections() {
        return List.of(this.file.name(), this.option.getDisplayName());
    }

    private void changeValue(MoneyValue value) {
        if (this.option.allowed.test(value)) {
            this.changeHandler.accept(value);
        }
    }
}

