/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders.discount_codes;

import com.google.common.collect.ImmutableSet;
import io.github.lightman314.lightmanscurrency.api.traders.discount_codes.IDiscountCodeSource;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TypedInputSource
implements IDiscountCodeSource {
    private final Set<String> codes;

    @Override
    public int priority() {
        return 100;
    }

    public TypedInputSource() {
        this(new HashSet<String>());
    }

    public TypedInputSource(Set<String> codes) {
        this.codes = new HashSet<String>(codes);
    }

    public void addCode(String code) {
        this.codes.add(code);
    }

    public void removeCode(String code) {
        this.codes.remove(code);
    }

    public void clearCodes() {
        this.codes.clear();
    }

    public Set<String> getCodes() {
        return ImmutableSet.copyOf(this.codes);
    }

    @Override
    public boolean containsCode(String code) {
        return this.codes.contains(code);
    }

    @Override
    public Set<Integer> getDiscountCodes() {
        return ImmutableSet.copyOf(this.codes.stream().map(Object::hashCode).toList());
    }

    @Override
    public boolean consumeCode(String code) {
        return this.containsCode(code);
    }
}

