/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.variants;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.variants.block.IVariantBlock;
import io.github.lightman314.lightmanscurrency.api.variants.block.VariantBlockWrapper;
import io.github.lightman314.lightmanscurrency.api.variants.item.IVariantItem;
import io.github.lightman314.lightmanscurrency.api.variants.item.VariantItemWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@ParametersAreNonnullByDefault
public class VariantProvider<T, V> {
    private static final VariantProvider<Block, IVariantBlock> BLOCK_PROVIDER = new VariantProvider(arg_0 -> ((IForgeRegistry)ForgeRegistries.BLOCKS).getKey(arg_0));
    private static final VariantProvider<Item, IVariantItem> ITEM_PROVIDER;
    private final List<Function<T, V>> providers = new ArrayList<Function<T, V>>();
    private final List<Pair<Predicate<T>, Function<T, V>>> builders = new ArrayList<Pair<Predicate<T>, Function<T, V>>>();
    private final Function<T, ResourceLocation> keyGetter;
    private final List<ResourceLocation> nullValues = new ArrayList<ResourceLocation>();
    private final Map<ResourceLocation, V> resultCache = new HashMap<ResourceLocation, V>();

    private void addProvider(Function<T, V> provider) {
        if (!this.resultCache.isEmpty() || !this.nullValues.isEmpty()) {
            LightmansCurrency.LogWarning("Variant Provider registered after results have already been cached!", new Throwable());
        }
        this.providers.add(Objects.requireNonNull(provider));
    }

    private void addBuilder(Predicate<T> test, Function<T, V> builder) {
        this.builders.add(Pair.of(test, builder));
    }

    public VariantProvider(Function<T, ResourceLocation> keyGetter) {
        this.keyGetter = keyGetter;
    }

    private void setupBuilderSource() {
        this.providers.add(object -> {
            for (Pair<Predicate<T>, Function<T, V>> builderPair : new ArrayList<Pair<Predicate<T>, Function<T, V>>>(this.builders)) {
                if (!((Predicate)builderPair.getFirst()).test(object)) continue;
                return ((Function)builderPair.getSecond()).apply(object);
            }
            return null;
        });
    }

    @Nullable
    public final V get(T value) {
        ResourceLocation key = this.keyGetter.apply(Objects.requireNonNull(value));
        if (this.resultCache.containsKey(key)) {
            return this.resultCache.get(key);
        }
        if (this.nullValues.contains(key)) {
            return null;
        }
        for (Function<T, V> provider : this.providers) {
            V result = provider.apply(value);
            if (result == null) continue;
            this.resultCache.put(key, result);
            return result;
        }
        this.nullValues.add(key);
        return null;
    }

    public static void registerVariantBlock(VariantBlockWrapper variant) {
        BLOCK_PROVIDER.addBuilder(block -> block == variant.getBlock(), b -> variant);
    }

    public static void registerVariantBlockBuilder(Predicate<Block> test, Function<Block, IVariantBlock> builder) {
        BLOCK_PROVIDER.addBuilder(test, builder);
    }

    public static void registerVariantBlock(Function<Block, IVariantBlock> provider) {
        BLOCK_PROVIDER.addProvider(Objects.requireNonNull(provider));
    }

    @SafeVarargs
    public static void registerBasicVariantItem(Supplier<Item> ... items) {
        ImmutableList list = ImmutableList.copyOf((Object[])items);
        VariantProvider.registerBasicVariantItemBuilder(arg_0 -> VariantProvider.lambda$registerBasicVariantItem$6((List)list, arg_0));
    }

    public static void registerBasicVariantItem(Item ... items) {
        ImmutableList list = ImmutableList.copyOf((Object[])items);
        VariantProvider.registerBasicVariantItemBuilder(((List)list)::contains);
    }

    public static void registerVariantItem(VariantItemWrapper variant) {
        ITEM_PROVIDER.addBuilder(item -> item == variant.getItem(), i -> variant);
    }

    public static void registerBasicVariantItemBuilder(Predicate<Item> test) {
        VariantProvider.registerVariantItemBuilder(test, VariantItemWrapper::simple);
    }

    public static void registerVariantItemBuilder(Predicate<Item> test, Function<Item, IVariantItem> builder) {
        ITEM_PROVIDER.addBuilder(test, builder);
    }

    public static void registerVariantItem(Function<Item, IVariantItem> provider) {
        ITEM_PROVIDER.addProvider(Objects.requireNonNull(provider));
    }

    @Nullable
    public static IVariantBlock getVariantBlock(Block block) {
        return BLOCK_PROVIDER.get(block);
    }

    @Nullable
    public static IVariantItem getVariantItem(ItemStack stack) {
        return VariantProvider.getVariantItem(stack.m_41720_());
    }

    @Nullable
    public static IVariantItem getVariantItem(Item item) {
        return ITEM_PROVIDER.get(item);
    }

    private static /* synthetic */ boolean lambda$registerBasicVariantItem$6(List list, Item item) {
        return list.stream().anyMatch(sup -> sup.get() == item);
    }

    static {
        BLOCK_PROVIDER.addProvider(b -> {
            if (b instanceof IVariantBlock) {
                IVariantBlock vb = (IVariantBlock)b;
                return vb;
            }
            return null;
        });
        BLOCK_PROVIDER.setupBuilderSource();
        ITEM_PROVIDER = new VariantProvider(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getKey(arg_0));
        ITEM_PROVIDER.addProvider(i -> {
            BlockItem bi;
            IVariantBlock block;
            if (i instanceof IVariantItem) {
                IVariantItem vi = (IVariantItem)i;
                return vi;
            }
            if (i instanceof BlockItem && (block = VariantProvider.getVariantBlock((bi = (BlockItem)i).m_40614_())) != null) {
                return VariantItemWrapper.simple(i);
            }
            return null;
        });
        ITEM_PROVIDER.setupBuilderSource();
    }
}

