/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.SpriteUtil;
import io.github.lightman314.lightmanscurrency.api.money.bank.BankAPI;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.BankAccountSelectButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidgetWithChildren;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.TextInputUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.components.EditBox;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BankAccountSelectionWidget
extends EasyWidgetWithChildren
implements IScrollable,
Comparator<BankReference> {
    private final int rows;
    private final Predicate<BankReference> filter;
    private final Supplier<BankReference> selectedAccount;
    private final Predicate<BankReference> accountActive;
    private final Predicate<BankReference> accountHighlighted;
    private final Consumer<BankReference> consumer;
    private EditBox searchBox;
    private String lastSearch = "";
    private int scroll = 0;

    private BankAccountSelectionWidget(Builder builder) {
        super(builder);
        this.rows = builder.rows;
        this.filter = builder.filter;
        this.selectedAccount = builder.selected;
        this.accountActive = builder.active;
        this.accountHighlighted = builder.highlighted;
        this.consumer = builder.handler;
        if (builder.oldWidget != null) {
            this.scroll = builder.oldWidget.scroll;
            this.lastSearch = builder.oldWidget.lastSearch;
        }
    }

    @Override
    public void addChildren(ScreenArea area) {
        this.searchBox = this.addChild(TextInputUtil.stringBuilder().position(area.pos.offset(area.width - 88, 2)).startingString(this.lastSearch).handler(s -> {
            this.lastSearch = s;
        }).size(79, 9).noBorder().build());
        this.addChild(((ScrollBarWidget.Builder)((ScrollBarWidget.Builder)ScrollBarWidget.builder().position(area.pos.offset(area.width, 12))).height(area.height - 12).scrollable(this).addon(EasyAddonHelper.visibleCheck(this::isVisible))).build());
        this.addChild(((ScrollListener.Builder)ScrollListener.builder().area(area)).listener(this).build());
        for (int i = 0; i < this.rows; ++i) {
            int index = i;
            this.addChild(((BankAccountSelectButton.Builder)((BankAccountSelectButton.Builder)BankAccountSelectButton.builder().position(area.pos.offset(0, 12 + i * 20))).width(this.f_93618_).pressAction(() -> this.selectAccount(index))).active(this.accountActive).highlight(this.accountHighlighted).account(() -> this.getAccount(index)).visible(this::isVisible).build());
        }
    }

    private List<BankReference> getBankAccounts() {
        ArrayList<BankReference> list = new ArrayList<BankReference>(BankAPI.getApi().GetAllBankReferences(true).stream().filter(this.filter).filter(this::searchFilter).toList());
        list.sort(this);
        return list;
    }

    private boolean searchFilter(BankReference reference) {
        IBankAccount account;
        if (this.lastSearch.isBlank()) {
            return true;
        }
        IBankAccount iBankAccount = account = reference == null ? null : reference.get();
        if (account == null) {
            return false;
        }
        return account.getName().getString().toLowerCase().contains(this.lastSearch.toLowerCase());
    }

    @Nullable
    private BankReference getAccount(int index) {
        List<BankReference> accounts = this.getBankAccounts();
        int i = index + this.scroll;
        if (i >= 0 && i < accounts.size()) {
            return accounts.get(i);
        }
        return null;
    }

    private void selectAccount(int index) {
        BankReference account = this.getAccount(index);
        if (account != null) {
            this.consumer.accept(account);
        }
    }

    @Override
    protected void renderWidget(EasyGuiGraphics gui) {
        SpriteUtil.SEARCH_FIELD.render(gui, this.f_93618_ - 90, 0, 90);
        gui.fill(ScreenArea.of(ScreenPosition.of(0, 12), this.f_93618_, this.f_93619_ - 12), -16777216);
    }

    @Override
    protected void renderTick() {
        this.searchBox.f_93624_ = this.f_93624_;
        if (this.f_93624_) {
            this.validateScroll();
        }
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
    }

    @Override
    public int getMaxScroll() {
        return IScrollable.calculateMaxScroll(this.rows, this.getBankAccounts().size());
    }

    @Override
    public int compare(BankReference rA, BankReference rB) {
        boolean matchA = this.isCurrentAccount(rA);
        boolean matchB = this.isCurrentAccount(rB);
        if (matchA && !matchB) {
            return -1;
        }
        if (matchB && !matchA) {
            return 1;
        }
        boolean hA = this.accountHighlighted.test(rA);
        boolean hB = this.accountHighlighted.test(rB);
        if (hA && !hB) {
            return -1;
        }
        if (hB && !hA) {
            return 1;
        }
        if (rA != null && rB == null) {
            return -1;
        }
        if (rB != null && rA == null) {
            return 1;
        }
        if (rA == null && rB == null) {
            return 0;
        }
        int priority = Integer.compare(rB.sortPriority(), rA.sortPriority());
        if (priority == 0) {
            IBankAccount baA = rA.get();
            IBankAccount baB = rB.get();
            if (baA != null && baB == null) {
                return -1;
            }
            if (baB != null && baA == null) {
                return 1;
            }
            if (baA == null && baB == null) {
                return 0;
            }
            return baA.getName().getString().compareToIgnoreCase(baB.getName().getString());
        }
        return priority;
    }

    private boolean isCurrentAccount(@Nullable BankReference reference) {
        return reference != null && reference.equals(this.selectedAccount.get());
    }

    public static Builder builder() {
        return new Builder();
    }

    @FieldsAreNonnullByDefault
    public static class Builder
    extends EasyWidget.EasyBuilder<Builder> {
        @Nullable
        BankAccountSelectionWidget oldWidget;
        int rows = 1;
        Supplier<BankReference> selected = () -> null;
        Predicate<BankReference> filter = r -> true;
        Predicate<BankReference> active = r -> true;
        Predicate<BankReference> highlighted = r -> false;
        Consumer<BankReference> handler = r -> {};

        private Builder() {
            super(100, 32);
        }

        @Override
        protected Builder getSelf() {
            return this;
        }

        public Builder oldWidget(@Nullable BankAccountSelectionWidget oldWidget) {
            this.oldWidget = oldWidget;
            return this;
        }

        public Builder width(int width) {
            this.changeWidth(width);
            return this;
        }

        public Builder rows(int rows) {
            this.rows = rows;
            this.changeHeight(rows * 20 + 12);
            return this;
        }

        public Builder filter(Predicate<BankReference> filter) {
            this.filter = filter;
            return this;
        }

        public Builder selected(Supplier<BankReference> selectedAccount) {
            this.selected = selectedAccount;
            this.active = r -> !r.equals(selectedAccount.get());
            return this;
        }

        public Builder active(Predicate<BankReference> activeCheck) {
            this.active = activeCheck;
            return this;
        }

        public Builder highlight(Predicate<BankReference> highlightCheck) {
            this.highlighted = highlightCheck;
            return this;
        }

        public Builder handler(Consumer<BankReference> handler) {
            this.handler = handler;
            return this;
        }

        public BankAccountSelectionWidget build() {
            return new BankAccountSelectionWidget(this);
        }
    }
}

