/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blocks;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.blocks.TraderBlockRotatable;
import io.github.lightman314.lightmanscurrency.api.variants.block.IVariantBlock;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.PaygateBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.items.TooltipItem;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.PaygateTraderData;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class PaygateBlock
extends TraderBlockRotatable
implements IVariantBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public PaygateBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public int modelsFromBlockState() {
        return 2;
    }

    @Override
    public int getModelIndex(BlockState state) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            return 1;
        }
        return 0;
    }

    @Override
    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult result) {
        PaygateTraderData trader;
        PaygateBlockEntity paygate;
        int tradeIndex;
        BlockEntity tileEntity;
        if (!level.f_46443_ && (tileEntity = level.m_7702_(pos)) instanceof PaygateBlockEntity && (tradeIndex = (paygate = (PaygateBlockEntity)tileEntity).getValidTicketTrade(player, player.m_21120_(hand))) >= 0 && (trader = (PaygateTraderData)paygate.getTraderData()) != null) {
            trader.TryExecuteTrade(TradeContext.create((TraderData)trader, player).build(), tradeIndex);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    @Override
    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWERED});
    }

    public boolean m_7899_(@Nonnull BlockState state) {
        return true;
    }

    public int m_6378_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull Direction dir) {
        Direction relativeSide;
        PaygateBlockEntity be;
        BlockEntity blockEntity;
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue() && (blockEntity = level.m_7702_(pos)) instanceof PaygateBlockEntity && (be = (PaygateBlockEntity)blockEntity).allowOutputSide(relativeSide = IRotatableBlock.getRelativeSide(this.getFacing(state), dir.m_122424_()))) {
            return be.getPowerLevel(relativeSide);
        }
        return 0;
    }

    @Override
    public void m_5871_(@Nonnull ItemStack stack, @Nullable BlockGetter level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        TooltipItem.addTooltip(tooltip, LCText.TOOLTIP_PAYGATE.asTooltip(new Object[0]));
        super.m_5871_(stack, level, tooltip, flagIn);
    }

    @Override
    protected BlockEntity makeTrader(BlockPos pos, BlockState state) {
        return new PaygateBlockEntity(pos, state);
    }

    @Override
    protected BlockEntityType<?> traderType() {
        return ModBlockEntities.PAYGATE.get();
    }
}

