/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.data.types;

import io.github.lightman314.lightmanscurrency.api.misc.data.CustomData;
import io.github.lightman314.lightmanscurrency.api.misc.data.CustomDataType;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.common.blockentity.TaxBlockEntity;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@FieldsAreNonnullByDefault
public class TaxDataCache
extends CustomData {
    public static final CustomDataType<TaxDataCache> TYPE = new CustomDataType<TaxDataCache>("lightmanscurrency_tax_data", TaxDataCache::new);
    private long nextID = 0L;
    private final Map<Long, TaxEntry> entries = new HashMap<Long, TaxEntry>();

    private TaxDataCache() {
    }

    @Override
    public CustomDataType<?> getType() {
        return TYPE;
    }

    @Override
    public void save(CompoundTag tag) {
        tag.m_128356_("NextID", this.nextID);
        ListTag entryList = new ListTag();
        this.entries.forEach((id, entry) -> {
            CompoundTag entryTag = entry.save();
            if (entryTag != null) {
                entryList.add((Object)entryTag);
            }
        });
        tag.m_128365_("TaxEntries", (Tag)entryList);
    }

    @Override
    protected void load(CompoundTag tag) {
        this.nextID = tag.m_128454_("NextID");
        ListTag list = tag.m_128437_("TaxEntries", 10);
        for (int i = 0; i < list.size(); ++i) {
            TaxEntry entry = new TaxEntry();
            entry.load(list.m_128728_(i));
            if (entry.getID() < 0L && !entry.isServerEntry()) continue;
            this.entries.put(entry.getID(), entry.unlock());
        }
    }

    public List<TaxEntry> getAllEntries() {
        return new ArrayList<TaxEntry>(this.entries.values());
    }

    @Nullable
    public TaxEntry getEntry(long id) {
        return this.entries.get(id);
    }

    public TaxEntry getServerEntry() {
        TaxEntry result = this.getEntry(-9L);
        if (result != null) {
            return result;
        }
        TaxEntry temp = new TaxEntry(-9L, null, null);
        this.entries.put(-9L, temp.unlock());
        this.markEntryDirty(-9L, temp.save());
        return temp;
    }

    public void markEntryDirty(long id, CompoundTag syncData) {
        if (id < 0L && id != -9L) {
            return;
        }
        this.setChanged();
        this.sendSyncPacket(this.builder().setCompound("UpdateEntry", syncData).setLong("ID", id));
    }

    public long createEntry(@Nullable TaxBlockEntity spawnBE, @Nullable Player player) {
        if (this.isClient()) {
            return -1L;
        }
        long id = this.nextID++;
        TaxEntry entry = new TaxEntry(id, spawnBE, player);
        this.entries.put(id, entry.unlock());
        this.markEntryDirty(id, entry.save());
        return id;
    }

    public void removeEntry(long id) {
        if (this.isClient()) {
            return;
        }
        if (this.entries.containsKey(id)) {
            this.entries.remove(id);
            this.setChanged();
            this.sendSyncPacket(this.builder().setLong("RemoveEntry", id));
        }
    }

    @Override
    protected void parseSyncPacket(LazyPacketData message) {
        if (message.contains("RemoveEntry")) {
            this.entries.remove(message.getLong("RemoveEntry"));
        }
        if (message.contains("UpdateEntry")) {
            long id = message.getLong("ID");
            CompoundTag data = message.getNBT("UpdateEntry");
            if (this.entries.containsKey(id)) {
                this.entries.get(id).load(data);
            } else {
                TaxEntry newEntry = new TaxEntry();
                newEntry.load(data);
                this.entries.put(id, newEntry.flagAsClient());
            }
        }
    }

    @Override
    public void onPlayerJoin(ServerPlayer player) {
        for (TaxEntry entry : this.entries.values()) {
            this.sendSyncPacket(this.builder().setCompound("UpdateEntry", entry.save()).setLong("ID", entry.getID()), player);
        }
    }
}

