/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.integration.computercraft.AccessTrackingPeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.LCComputerHelper;
import io.github.lightman314.lightmanscurrency.integration.computercraft.LCPeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.LCPeripheralMethod;
import io.github.lightman314.lightmanscurrency.integration.computercraft.data.LCLuaTable;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.TraderPeripheral;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class MultiTraderPeripheral
extends AccessTrackingPeripheral {
    public static final String BASE_TYPE = "lc_multi_trader";

    public Set<String> getAdditionalTypes() {
        return Set.of(BASE_TYPE);
    }

    protected abstract List<TraderData> getAccessibleTraders();

    protected abstract boolean stillAccessible(TraderData var1);

    @Override
    protected boolean childStillValid(IPeripheral child) {
        if (child instanceof TraderPeripheral) {
            TraderPeripheral tp = (TraderPeripheral)child;
            Object trader = tp.safeGetTrader();
            if (trader == null) {
                return false;
            }
            return this.stillAccessible((TraderData)trader);
        }
        return true;
    }

    @Override
    protected void registerMethods(LCPeripheralMethod.Registration registration) {
        registration.register(LCPeripheralMethod.builder("getTraderIDs").simpleArray(this::getTraderIDs));
        registration.register(LCPeripheralMethod.builder("getBasicTraderInfo").simple(this::getBasicTraderInfo));
        registration.register(LCPeripheralMethod.builder("searchTraders").withArgs(this::searchTraders));
        registration.register(LCPeripheralMethod.builder("getTrader").withContextArray(this::getTrader));
    }

    public Long[] getTraderIDs() {
        ArrayList<Long> list = new ArrayList<Long>();
        for (TraderData trader : this.getAccessibleTraders()) {
            list.add(trader.getID());
        }
        return (Long[])list.toArray(Long[]::new);
    }

    public LCLuaTable getBasicTraderInfo() {
        return MultiTraderPeripheral.collectTraderInfo(this.getAccessibleTraders());
    }

    public LCLuaTable searchTraders(IArguments args) throws LuaException {
        return MultiTraderPeripheral.collectTraderInfo(TraderAPI.getApi().FilterTraders(this.getAccessibleTraders(), args.getString(0)));
    }

    private static LCLuaTable collectTraderInfo(List<TraderData> traders) {
        LCLuaTable table = new LCLuaTable();
        for (TraderData trader : traders) {
            LCLuaTable entry = new LCLuaTable();
            entry.put("Name", trader.getName().getString());
            entry.put("Owner", trader.getOwner().getName().getString());
            LCPeripheral peripheral = LCComputerHelper.getPeripheral(trader);
            ArrayList<String> types = new ArrayList<String>();
            types.add(peripheral.getType());
            types.addAll(peripheral.getAdditionalTypes());
            entry.put("Types", types.toArray(String[]::new));
            table.put(trader.getID(), entry);
        }
        return table;
    }

    public Object[] getTrader(IComputerAccess computer, IArguments args) throws LuaException {
        TraderData trader = TraderAPI.getApi().GetTrader(false, (long)args.getInt(0));
        if (trader == null || !this.stillAccessible(trader)) {
            return new Object[]{null, new LuaException("Trader could not be located")};
        }
        LCPeripheral result = LCComputerHelper.getPeripheral(trader);
        if (result instanceof AccessTrackingPeripheral) {
            AccessTrackingPeripheral at = (AccessTrackingPeripheral)result;
            at.setParent(this);
        }
        return new Object[]{result.asTable(computer), null};
    }
}

