/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.events;

import io.github.lightman314.lightmanscurrency.common.attachments.WalletHandler;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class WalletDropEvent
extends PlayerEvent
implements ICancellableEvent {
    private Container walletInventory;
    private ItemStack walletStack;
    public final DamageSource source;
    private List<ItemStack> walletDrops = new ArrayList<ItemStack>();
    public final boolean keepWallet;
    public final int coinDropPercent;

    @Nonnull
    public Container getWalletInventory() {
        return this.walletInventory;
    }

    @Nonnull
    public ItemStack getWalletStack() {
        ItemStack result = this.walletStack.copy();
        if (WalletItem.isWallet(result)) {
            WalletItem.getDataWrapper(result).setContents(this.walletInventory, null);
        }
        return result;
    }

    public void setWalletStack(@Nonnull ItemStack wallet) {
        this.walletStack = wallet.copy();
        this.walletInventory = WalletItem.getDataWrapper(wallet).getContents();
    }

    @Nonnull
    public List<ItemStack> getDrops() {
        return this.walletDrops;
    }

    public void setDrops(@Nonnull List<ItemStack> drops) {
        this.walletDrops = new ArrayList<ItemStack>(drops);
    }

    public void addDrop(@Nonnull ItemStack drop) {
        this.walletDrops.add(drop);
    }

    public void addDrops(@Nonnull Collection<ItemStack> drop) {
        this.walletDrops.addAll(drop);
    }

    public WalletDropEvent(@Nonnull Player player, @Nonnull WalletHandler walletHandler, @Nonnull DamageSource source, boolean keepWallet, int coinDropPercent) {
        super(player);
        this.walletStack = walletHandler.getWallet().copy();
        this.walletInventory = WalletItem.getDataWrapper(this.walletStack).getContents();
        this.source = source;
        this.keepWallet = keepWallet;
        this.coinDropPercent = coinDropPercent;
    }
}

