/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.client.sprites;

import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.FixedSizeSprite;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public interface FlexibleSizeSprite {
    default public void render(EasyGuiGraphics gui, ScreenArea area) {
        this.render(gui, area.pos, area.width, area.height);
    }

    default public void render(EasyGuiGraphics gui, ScreenPosition pos, int width, int height) {
        this.render(gui, pos.x, pos.y, width, height);
    }

    public void render(EasyGuiGraphics var1, int var2, int var3, int var4, int var5);

    default public boolean canFitInSize(int width, int height) {
        return true;
    }

    default public FixedSizeSprite ofSize(int width, int height) {
        return new FixedSprite(this, width, height);
    }

    public static class FixedSprite
    implements FixedSizeSprite {
        private final FlexibleSizeSprite sprite;
        private final int width;
        private final int height;

        private FixedSprite(FlexibleSizeSprite sprite, int width, int height) {
            this.sprite = sprite;
            this.width = width;
            this.height = height;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public void render(EasyGuiGraphics gui, int x, int y) {
            if (this.sprite.canFitInSize(this.width, this.height)) {
                this.sprite.render(gui, x, y, this.width, this.height);
            }
        }
    }
}

