/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.util.LookupHelper;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;

public interface ITraderSource {
    public static final ITraderSource CLIENT_TRADER_SOURCE = new NetworkTraderSource(true);
    public static final ITraderSource SERVER_TRADER_SOURCE = new NetworkTraderSource(false);

    @Nonnull
    public List<TraderData> getTraders();

    public boolean isSingleTrader();

    @Nonnull
    default public TraderData getSingleTrader() {
        return this.getTraders().getFirst();
    }

    @Nonnull
    public RegistryAccess registryAccess();

    default public boolean showSearchBox() {
        return false;
    }

    @Nullable
    default public Component getCustomTitle() {
        return null;
    }

    public static Supplier<ITraderSource> NetworkTraderSource(boolean isClient) {
        return isClient ? () -> CLIENT_TRADER_SOURCE : () -> SERVER_TRADER_SOURCE;
    }

    public static class NetworkTraderSource
    implements ITraderSource {
        private final boolean isClient;

        private NetworkTraderSource(boolean isClient) {
            this.isClient = isClient;
        }

        @Override
        @Nullable
        public Component getCustomTitle() {
            return LCText.GUI_TRADER_ALL_NETWORK_TRADERS.get(new Object[0]);
        }

        @Override
        public boolean showSearchBox() {
            return true;
        }

        @Override
        @Nonnull
        public List<TraderData> getTraders() {
            return TraderAPI.getApi().GetAllNetworkTraders(this.isClient);
        }

        @Override
        public boolean isSingleTrader() {
            return false;
        }

        @Override
        @Nonnull
        public RegistryAccess registryAccess() {
            return LookupHelper.getRegistryAccess();
        }
    }
}

