/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders.blockentity;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.IServerTicker;
import io.github.lightman314.lightmanscurrency.api.misc.blockentity.EasyBlockEntity;
import io.github.lightman314.lightmanscurrency.api.misc.blockentity.IOwnableBlockEntity;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.PlayerOwner;
import io.github.lightman314.lightmanscurrency.api.taxes.ITaxCollector;
import io.github.lightman314.lightmanscurrency.api.taxes.TaxAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderState;
import io.github.lightman314.lightmanscurrency.api.traders.blocks.TraderBlockBase;
import io.github.lightman314.lightmanscurrency.api.upgrades.IUpgradeable;
import io.github.lightman314.lightmanscurrency.api.upgrades.IUpgradeableBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.common.items.data.TraderItemData;
import io.github.lightman314.lightmanscurrency.network.message.trader.SPacketTaxInfo;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;

public abstract class TraderBlockEntity<D extends TraderData>
extends EasyBlockEntity
implements IOwnableBlockEntity,
IServerTicker,
IUpgradeableBlockEntity {
    private long traderID = -1L;
    private CompoundTag customTrader = null;
    private boolean ignoreCustomTrader = false;
    private boolean selfPickup = false;
    private boolean legitimateBreak = false;

    public long getTraderID() {
        return this.traderID;
    }

    @Deprecated
    public void setTraderID(long traderID) {
        this.traderID = traderID;
    }

    public void flagAsPickup() {
        this.selfPickup = true;
    }

    public boolean isSelfPickup() {
        return this.selfPickup;
    }

    public void flagAsLegitBreak() {
        this.legitimateBreak = true;
    }

    public boolean legitimateBreak() {
        return this.legitimateBreak;
    }

    public boolean supportsTraderPickup() {
        return true;
    }

    public ItemStack PickupTrader(@Nonnull Player player, @Nonnull TraderData trader) {
        if (!this.supportsTraderPickup() || trader.getID() != this.traderID) {
            return ItemStack.EMPTY;
        }
        BlockState state = this.level.getBlockState(this.worldPosition);
        Block block = state.getBlock();
        if (block instanceof TraderBlockBase) {
            TraderBlockBase block2 = (TraderBlockBase)block;
            this.selfPickup = true;
            this.legitimateBreak = true;
            block2.removeAllBlocks(this.level, state, this.worldPosition);
            return new ItemStack((ItemLike)state.getBlock());
        }
        return ItemStack.EMPTY;
    }

    public TraderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    private D buildTrader(Player owner, ItemStack placementStack) {
        D newTrader;
        if (this.customTrader != null && (newTrader = this.fullyBuildCustomTrader()) != null) {
            return newTrader;
        }
        newTrader = this.buildNewTrader();
        ((TraderData)newTrader).getOwner().SetOwner(PlayerOwner.of(owner));
        if (placementStack.has(DataComponents.CUSTOM_NAME)) {
            ((TraderData)newTrader).setCustomName(placementStack.getHoverName().getString());
        }
        return newTrader;
    }

    protected final D initCustomTrader() {
        try {
            return (D)TraderData.Deserialize(false, this.customTrader, (HolderLookup.Provider)this.level.registryAccess());
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error while attempting to load the custom trader!", t);
            return null;
        }
    }

    protected final D fullyBuildCustomTrader() {
        try {
            D newTrader = this.initCustomTrader();
            this.moveCustomTrader(newTrader);
            return newTrader;
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error while attempting to load the custom trader!", t);
            return null;
        }
    }

    protected final void moveCustomTrader(D customTrader) {
        if (customTrader != null) {
            ((TraderData)customTrader).move(this.level, this.worldPosition);
        }
    }

    @Nonnull
    protected abstract D buildNewTrader();

    public final void saveCurrentTraderAsCustomTrader() {
        D trader = this.getTraderData();
        if (trader != null) {
            this.customTrader = ((TraderData)trader).save((HolderLookup.Provider)this.level.registryAccess());
            this.ignoreCustomTrader = true;
            this.markDirty();
        }
    }

    @Nullable
    private CompoundTag getCurrentTraderAsTag() {
        TraderData trader = this.getRawTraderData();
        if (trader != null) {
            return trader.save((HolderLookup.Provider)this.level.registryAccess());
        }
        return null;
    }

    public void initialize(@Nonnull Player owner, @Nonnull ItemStack placementStack) {
        if (this.getTraderData() != null) {
            return;
        }
        if (placementStack.has(ModDataComponents.TRADER_ITEM_DATA)) {
            TraderItemData data = (TraderItemData)placementStack.get(ModDataComponents.TRADER_ITEM_DATA);
            TraderData trader = TraderAPI.getApi().GetTrader(this, data.traderID());
            if (trader != null && this.castOrNullify(trader) != null && trader.isRecoverable()) {
                this.traderID = data.traderID();
                this.markDirty();
                trader.move(this.level, this.worldPosition);
                trader.setState(TraderState.NORMAL);
                this.checkTaxes(owner, trader);
                return;
            }
        }
        D newTrader = this.buildTrader(owner, placementStack);
        if (this.getCurrentVariant() != null) {
            ((TraderData)newTrader).setTraderBlockVariant(this.getCurrentVariant(), this.isVariantLocked());
        }
        this.traderID = TraderAPI.getApi().CreateTrader((TraderData)newTrader, owner);
        this.checkTaxes(owner, (TraderData)newTrader);
        this.markDirty();
        this.level.invalidateCapabilities(this.worldPosition);
    }

    private void checkTaxes(@Nonnull Player player, @Nonnull TraderData trader) {
        List<ITaxCollector> taxes = TaxAPI.getApi().AcknowledgeTaxCollectors(trader);
        if (!taxes.isEmpty()) {
            SPacketTaxInfo.sendPacket(taxes, player);
        }
    }

    public TraderData getRawTraderData() {
        return TraderAPI.getApi().GetTrader(this.isClient(), this.traderID);
    }

    public D getTraderData() {
        TraderData rawData = this.getRawTraderData();
        if (rawData == null) {
            return null;
        }
        return this.castOrNullify(rawData);
    }

    @Nullable
    protected abstract D castOrNullify(@Nonnull TraderData var1);

    @Override
    public void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        super.saveAdditional(compound, lookup);
        compound.putLong("TraderID", this.traderID);
        if (this.customTrader != null) {
            compound.put("CustomTrader", (Tag)this.customTrader);
        }
    }

    @Override
    protected void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        super.loadAdditional(compound, lookup);
        if (compound.contains("TraderID", 4)) {
            this.traderID = compound.getLong("TraderID");
        }
        if (compound.contains("CustomTrader")) {
            this.customTrader = compound.getCompound("CustomTrader");
        }
    }

    @Override
    public void serverTick() {
        if (this.level == null) {
            return;
        }
        if (this.customTrader != null && !this.ignoreCustomTrader) {
            D customTrader = this.initCustomTrader();
            if (customTrader == null) {
                LightmansCurrency.LogWarning("The trader block at " + this.worldPosition.toShortString() + " could not properly load it's custom trader.");
                this.customTrader = null;
            }
            if (((TraderData)customTrader).getLevel() == this.level.dimension() && this.worldPosition.equals((Object)((TraderData)customTrader).getPos())) {
                this.ignoreCustomTrader = true;
            } else {
                this.moveCustomTrader(customTrader);
                this.traderID = TraderAPI.getApi().CreateTrader((TraderData)customTrader, null);
                this.customTrader = null;
                this.ignoreCustomTrader = true;
                this.markDirty();
                this.level.invalidateCapabilities(this.worldPosition);
                LightmansCurrency.LogInfo("Successfully loaded custom trader at " + this.worldPosition.toShortString());
            }
        }
    }

    public final void markDirty() {
        this.setChanged();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket(this);
        }
    }

    @Override
    public void onLoad() {
        if (this.isServer()) {
            this.moveCustomTrader(this.getTraderData());
        }
        super.onLoad();
    }

    public static <X> void easyRegisterCapProvider(@Nonnull RegisterCapabilitiesEvent event, @Nonnull BlockCapability<X, Direction> cap, @Nonnull BiFunction<TraderData, Direction, X> getter, Block ... blocks) {
        event.registerBlock(cap, (level, pos, state, be, side) -> {
            TraderBlockEntity traderBE;
            TraderData trader;
            if (be instanceof TraderBlockEntity && (trader = (traderBE = (TraderBlockEntity)be).getRawTraderData()) != null) {
                Direction relativeSide = side;
                Block patt0$temp = state.getBlock();
                if (patt0$temp instanceof IRotatableBlock) {
                    IRotatableBlock rb = (IRotatableBlock)patt0$temp;
                    relativeSide = IRotatableBlock.getRelativeSide(rb.getFacing(state), side);
                }
                return getter.apply(trader, relativeSide);
            }
            return null;
        }, blocks);
    }

    @Override
    public boolean canBreak(@Nullable Player player) {
        D trader = this.getTraderData();
        if (trader != null) {
            return ((TraderData)trader).hasPermission(player, "breakTrader");
        }
        return true;
    }

    public void onBreak() {
        TraderAPI.getApi().DeleteTrader(this.traderID);
    }

    @Nullable
    public static AABB getRenderBoundingBox(@Nonnull TraderBlockEntity<?> be) {
        if (be.getBlockState() != null) {
            return be.getBlockState().getCollisionShape((BlockGetter)be.level, be.worldPosition).bounds().move(be.worldPosition);
        }
        return null;
    }

    @Override
    @Nullable
    public IUpgradeable getUpgradeable() {
        return this.getTraderData();
    }

    @Override
    public void setVariant(@Nullable ResourceLocation variant, boolean locked) {
        super.setVariant(variant, locked);
        D t = this.getTraderData();
        if (t != null) {
            ((TraderData)t).setTraderBlockVariant(variant, locked);
        }
    }
}

