/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.easy;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.InputConstants;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.IEasyTickable;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyScreenHelper;
import io.github.lightman314.lightmanscurrency.client.gui.easy.GhostSlot;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IEasyScreen;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IGhostSlotProvider;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IKeyboardListener;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.ILateRender;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IMouseListener;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IPreRender;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IRemovalListener;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.ITooltipSource;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IWidgetWrapper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidgetWithChildren;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class EasyMenuScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T>
implements IEasyScreen {
    @Nullable
    private List<Renderable> renderableCache = null;
    private final List<IPreRender> preRenders = new ArrayList<IPreRender>();
    private final List<ILateRender> lateRenders = new ArrayList<ILateRender>();
    private final List<IEasyTickable> guiTickers = new ArrayList<IEasyTickable>();
    private final List<ITooltipSource> tooltipSources = new ArrayList<ITooltipSource>();
    private final List<IScrollListener> scrollListeners = new ArrayList<IScrollListener>();
    private final List<IMouseListener> mouseListeners = new ArrayList<IMouseListener>();
    private final List<IKeyboardListener> keyboardListeners = new ArrayList<IKeyboardListener>();
    private final List<IGhostSlotProvider> ghostSlotProviders = new ArrayList<IGhostSlotProvider>();
    private final List<IRemovalListener> removalListeners = new ArrayList<IRemovalListener>();
    ScreenArea screenArea = ScreenArea.of(0, 0, 100, 100);

    private List<Renderable> getActiveRenderableList() {
        return this.renderableCache == null ? this.renderables : this.renderableCache;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public Player getPlayer() {
        return this.minecraft.player;
    }

    @Override
    public RegistryAccess registryAccess() {
        return this.getPlayer().registryAccess();
    }

    protected EasyMenuScreen(T menu, Inventory inventory) {
        this(menu, inventory, (Component)EasyText.empty());
    }

    protected EasyMenuScreen(T menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
    }

    @Override
    public final ScreenArea getArea() {
        return this.screenArea;
    }

    @Override
    public final int getGuiLeft() {
        return this.screenArea.x;
    }

    @Override
    public final int getGuiTop() {
        return this.screenArea.y;
    }

    @Override
    public final ScreenPosition getCorner() {
        return this.screenArea.pos;
    }

    @Override
    public final int getXSize() {
        return this.screenArea.width;
    }

    @Override
    public final int getYSize() {
        return this.screenArea.height;
    }

    protected final ScreenArea resize(int width, int height) {
        this.screenArea = this.screenArea.ofSize(width, height);
        this.recalculateCorner();
        this.leftPos = this.screenArea.x;
        this.topPos = this.screenArea.y;
        this.imageWidth = this.screenArea.width;
        this.imageHeight = this.screenArea.height;
        return this.screenArea;
    }

    protected void recalculateCorner() {
        this.screenArea = this.screenArea.atPosition(ScreenPosition.of((this.width - this.screenArea.width) / 2, (this.height - this.screenArea.height) / 2));
        this.topPos = this.screenArea.y;
        this.leftPos = this.screenArea.x;
    }

    protected final void init() {
        this.preRenders.clear();
        this.lateRenders.clear();
        this.guiTickers.clear();
        this.tooltipSources.clear();
        this.scrollListeners.clear();
        this.mouseListeners.clear();
        this.keyboardListeners.clear();
        this.ghostSlotProviders.clear();
        for (IRemovalListener l : this.removalListeners) {
            l.onRemovedFromScreen();
        }
        this.removalListeners.clear();
        this.preInit();
        this.recalculateCorner();
        this.initialize(this.screenArea);
    }

    protected void preInit() {
    }

    protected abstract void initialize(ScreenArea var1);

    public final void renderTransparentBackground(GuiGraphics gui) {
        if (((Boolean)LCConfig.CLIENT.debugScreens.get()).booleanValue()) {
            gui.fill(0, 0, this.width, this.height, -65794);
        } else {
            super.renderTransparentBackground(gui);
        }
    }

    public final void render(GuiGraphics mcgui, int mouseX, int mouseY, float partialTicks) {
        this.renderTick();
        EasyGuiGraphics gui = EasyGuiGraphics.create(mcgui, this.font, mouseX, mouseY, partialTicks).pushOffset(this.getCorner());
        for (Object r : ImmutableList.copyOf(this.preRenders)) {
            try {
                r.preRender(gui);
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error occurred while early rendering " + r.getClass().getName(), t);
            }
        }
        this.renderTransparentBackground(mcgui);
        this.renderBG(gui);
        for (Renderable renderable : new ArrayList(this.renderables)) {
            renderable.render(mcgui, mouseX, mouseY, partialTicks);
        }
        this.renderableCache = new ArrayList<Renderable>(this.renderables);
        this.renderables.clear();
        super.render(mcgui, mouseX, mouseY, partialTicks);
        this.renderables.addAll(this.renderableCache);
        this.renderableCache = null;
        for (Object r : ImmutableList.copyOf(this.lateRenders)) {
            try {
                r.lateRender(gui);
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error occurred while late rendering " + r.getClass().getName(), t);
            }
        }
        this.renderAfterWidgets(gui);
        this.renderTooltip(mcgui, mouseX, mouseY);
        EasyScreenHelper.RenderTooltips(gui, (List<ITooltipSource>)ImmutableList.copyOf(this.tooltipSources));
        this.renderAfterTooltips(gui);
    }

    protected void renderTick() {
    }

    public final void renderBackground(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
    }

    protected final void renderBg(GuiGraphics gui, float partialTicks, int mouseX, int mouseY) {
    }

    protected abstract void renderBG(EasyGuiGraphics var1);

    protected final void renderLabels(GuiGraphics gui, int mouseX, int mouseY) {
    }

    protected void renderAfterWidgets(EasyGuiGraphics gui) {
    }

    protected void renderAfterTooltips(EasyGuiGraphics gui) {
    }

    @Override
    public final <W> W addChild(W child) {
        Object l;
        ITooltipSource t;
        IEasyTickable ticker;
        Object r;
        Object w;
        if (child instanceof EasyWidget.EasyBuilder) {
            LightmansCurrency.LogError("Builder accidentally passed along as a widget!", new Throwable());
        }
        if (child instanceof EasyWidgetWithChildren) {
            w = (EasyWidgetWithChildren)((Object)child);
            ((EasyWidgetWithChildren)((Object)w)).pairWithScreen(this::addChild, this::removeChild);
            if (((EasyWidgetWithChildren)((Object)w)).addChildrenBeforeThis()) {
                ((EasyWidgetWithChildren)((Object)w)).addChildren();
            }
        }
        if (child instanceof Renderable) {
            r = (Renderable)child;
            if (!this.getActiveRenderableList().contains(child)) {
                this.getActiveRenderableList().add((Renderable)r);
            }
        }
        if (child instanceof GuiEventListener && child instanceof NarratableEntry) {
            super.addWidget((GuiEventListener)((NarratableEntry)child));
        }
        if (child instanceof IEasyTickable && !this.guiTickers.contains(ticker = (IEasyTickable)child)) {
            this.guiTickers.add(ticker);
        }
        if (child instanceof ITooltipSource && !this.tooltipSources.contains(t = (ITooltipSource)child)) {
            this.tooltipSources.add(t);
        }
        if (child instanceof IMouseListener && !this.mouseListeners.contains(l = (IMouseListener)child)) {
            this.mouseListeners.add((IMouseListener)l);
        }
        if (child instanceof IScrollListener && !this.scrollListeners.contains(l = (IScrollListener)child)) {
            this.scrollListeners.add((IScrollListener)l);
        }
        if (child instanceof IPreRender && !this.preRenders.contains(r = (IPreRender)child)) {
            this.preRenders.add((IPreRender)r);
        }
        if (child instanceof ILateRender && !this.lateRenders.contains(r = (ILateRender)child)) {
            this.lateRenders.add((ILateRender)r);
        }
        if (child instanceof EasyWidget) {
            w = (EasyWidget)((Object)child);
            ((EasyWidget)((Object)w)).addAddons(this::addChild);
        }
        if (child instanceof IKeyboardListener) {
            l = (IKeyboardListener)child;
            this.keyboardListeners.add((IKeyboardListener)l);
        }
        if (child instanceof IGhostSlotProvider) {
            IGhostSlotProvider p = (IGhostSlotProvider)child;
            this.ghostSlotProviders.add(p);
        }
        if (child instanceof IRemovalListener) {
            l = (IRemovalListener)child;
            this.removalListeners.add((IRemovalListener)l);
        }
        if (child instanceof EasyWidgetWithChildren && !((EasyWidgetWithChildren)((Object)(w = (EasyWidgetWithChildren)((Object)child)))).addChildrenBeforeThis()) {
            ((EasyWidgetWithChildren)((Object)w)).addChildren();
        }
        if (child instanceof IWidgetWrapper) {
            w = (IWidgetWrapper)child;
            this.addChild(w.getWrappedWidget());
        }
        return child;
    }

    @Override
    public final void removeChild(Object child) {
        Object w;
        Object l;
        Object r;
        if (child instanceof Renderable) {
            r = (Renderable)child;
            this.getActiveRenderableList().remove(r);
        }
        if (child instanceof GuiEventListener) {
            l = (GuiEventListener)child;
            super.removeWidget((GuiEventListener)l);
        }
        if (child instanceof IEasyTickable) {
            IEasyTickable ticker = (IEasyTickable)child;
            this.guiTickers.remove(ticker);
        }
        if (child instanceof ITooltipSource) {
            ITooltipSource t = (ITooltipSource)child;
            this.tooltipSources.remove(t);
        }
        if (child instanceof IMouseListener) {
            l = (IMouseListener)child;
            this.mouseListeners.remove(l);
        }
        if (child instanceof IScrollListener) {
            l = (IScrollListener)child;
            this.scrollListeners.remove(l);
        }
        if (child instanceof EasyWidget) {
            w = (EasyWidget)((Object)child);
            ((EasyWidget)((Object)w)).removeAddons(this::removeChild);
        }
        if (child instanceof IPreRender) {
            r = (IPreRender)child;
            this.preRenders.remove(r);
        }
        if (child instanceof ILateRender) {
            r = (ILateRender)child;
            this.lateRenders.remove(r);
        }
        if (child instanceof IKeyboardListener) {
            l = (IKeyboardListener)child;
            this.keyboardListeners.remove(l);
        }
        if (child instanceof IGhostSlotProvider) {
            IGhostSlotProvider p = (IGhostSlotProvider)child;
            this.ghostSlotProviders.remove(p);
        }
        if (child instanceof IRemovalListener) {
            l = (IRemovalListener)child;
            l.onRemovedFromScreen();
            this.removalListeners.remove(l);
        }
        if (child instanceof EasyWidgetWithChildren) {
            w = (EasyWidgetWithChildren)((Object)child);
            ((EasyWidgetWithChildren)((Object)w)).removeChildren();
        }
        if (child instanceof IWidgetWrapper) {
            w = (IWidgetWrapper)child;
            this.removeChild(w.getWrappedWidget());
        }
    }

    protected final void containerTick() {
        for (IEasyTickable t : ImmutableList.copyOf(this.guiTickers)) {
            t.tick();
        }
        this.screenTick();
    }

    protected void screenTick() {
    }

    @Deprecated
    protected final <W extends GuiEventListener & NarratableEntry> W addWidget(W widget) {
        return (W)((GuiEventListener)this.addChild(widget));
    }

    @Deprecated
    protected final <W extends GuiEventListener & Renderable> W addRenderableWidget(W widget) {
        return (W)((GuiEventListener)this.addChild(widget));
    }

    @Deprecated
    protected final <W extends Renderable> W addRenderableOnly(W widget) {
        return this.addChild(widget);
    }

    @Deprecated
    protected final void removeWidget(GuiEventListener widget) {
        this.removeChild(widget);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        for (IScrollListener l : ImmutableList.copyOf(this.scrollListeners)) {
            if (!l.mouseScrolled(mouseX, mouseY, deltaY)) continue;
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (IMouseListener l : ImmutableList.copyOf(this.mouseListeners)) {
            if (!l.onMouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        for (IMouseListener l : ImmutableList.copyOf(this.mouseListeners)) {
            if (!l.onMouseReleased(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (IKeyboardListener listener : new ArrayList<IKeyboardListener>(this.keyboardListeners)) {
            if (!listener.onKeyPress(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        InputConstants.Key mouseKey = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey) && this.blockInventoryClosing()) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public List<GhostSlot<?>> getGhostSlots() {
        ArrayList list = new ArrayList();
        for (IGhostSlotProvider provider : new ArrayList<IGhostSlotProvider>(this.ghostSlotProviders)) {
            List<GhostSlot<?>> entries = provider.getGhostSlots();
            if (entries == null) continue;
            list.addAll(entries);
        }
        return list;
    }
}

