/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.walletbank;

import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.ItemIcon;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyViewer;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.WalletBankScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.walletbank.WalletBankTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.bank.BankInteractionWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.bank.IBankInteractionHandler;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.menus.wallet.WalletBankMenu;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class InteractionTab
extends WalletBankTab
implements IBankInteractionHandler {
    BankInteractionWidget accountWidget;

    public InteractionTab(WalletBankScreen screen) {
        super(screen);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return ItemIcon.ofItem(ModBlocks.COINPILE_GOLD);
    }

    public MutableComponent getTooltip() {
        return Component.translatable((String)"tooltip.lightmanscurrency.atm.interact");
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.accountWidget = this.addChild(((BankInteractionWidget.Builder)BankInteractionWidget.builder().position(screenArea.pos.offset(((WalletBankMenu)this.menu).halfBonusWidth, 0))).handler(this).spacing(12).blockEmptyDeposits().build());
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        MutableComponent accountName = Component.literal((String)"ERROR FINDING ACCOUNT");
        IBankAccount ba = ((WalletBankMenu)((WalletBankScreen)this.screen).getMenu()).getBankAccount();
        if (ba != null) {
            accountName = ba.getName();
        }
        TextRenderUtil.drawCenteredText(gui, TextRenderUtil.fitString((Component)accountName, ((WalletBankScreen)this.screen).getXSize() - 12), ((WalletBankScreen)this.screen).getXSize() / 2, 70, 0x404040);
    }

    @Override
    public IBankAccount getBankAccount() {
        return ((WalletBankMenu)((WalletBankScreen)this.screen).getMenu()).getBankAccount();
    }

    @Override
    public IMoneyViewer getCoinAccess() {
        return ((WalletBankMenu)((WalletBankScreen)this.screen).getMenu()).getCoinInputHandler();
    }
}

