/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.models;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.data.ModelVariant;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.models.VariantModelHelper;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.models.VariantModelLocation;
import io.github.lightman314.lightmanscurrency.common.blocks.variant.IVariantBlock;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.block.model.MultiVariant;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.BlockStateModelLoader;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;

public class VariantModelBakery {
    private static final Map<String, String> BUILTIN_MODELS = Map.of("missing", ModelBakery.MISSING_MODEL_MESH);
    private final ItemModelGenerator ITEM_MODEL_GENERATOR = new ItemModelGenerator();
    private final Map<ResourceLocation, BlockModel> modelResources;
    private final Set<ResourceLocation> loadingStack = new HashSet<ResourceLocation>();
    private final Map<ResourceLocation, UnbakedModel> unbakedCache = new HashMap<ResourceLocation, UnbakedModel>();
    private final Map<ResourceLocation, List<BlockStateModelLoader.LoadedJson>> blockStates;
    private final Map<ResourceLocation, List<ResourceLocation>> defaultModels = new HashMap<ResourceLocation, List<ResourceLocation>>();
    private final Map<ModelCacheKey, UnbakedModel> topLevelModels = new HashMap<ModelCacheKey, UnbakedModel>();
    private final Map<ModelCacheKey, BakedModel> bakedTopLevelModels = new HashMap<ModelCacheKey, BakedModel>();
    private final Multimap<ModelCacheKey, VariantModelLocation> keyToVariantLocation = HashMultimap.create();
    private final UnbakedModel missingModel;

    public int getBakedModelCount() {
        return this.bakedTopLevelModels.size();
    }

    public final Map<VariantModelLocation, BakedModel> getBakedTopLevelModels() {
        HashMap result = new HashMap();
        Map keyCollectionMap = this.keyToVariantLocation.asMap();
        this.bakedTopLevelModels.forEach((key, model) -> {
            for (VariantModelLocation modelLocation : (Collection)keyCollectionMap.getOrDefault(key, new ArrayList())) {
                result.put(modelLocation, model);
            }
        });
        return ImmutableMap.copyOf(result);
    }

    public VariantModelBakery(BlockColors blockColors, ProfilerFiller profilerFiller, Map<ResourceLocation, BlockModel> modelResources, Map<ResourceLocation, List<BlockStateModelLoader.LoadedJson>> blockStates, Map<ResourceLocation, ModelVariant> variants) {
        this.modelResources = new HashMap<ResourceLocation, BlockModel>(modelResources);
        this.blockStates = blockStates;
        profilerFiller.push("missing_model");
        try {
            this.missingModel = this.loadBlockModel(ModelBakery.MISSING_MODEL_LOCATION);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading missing model!", e);
        }
        profilerFiller.popPush("variant models");
        variants.forEach((id, variant) -> {
            LightmansCurrency.LogDebug("Generating and loading models for variant " + String.valueOf(id));
            for (ResourceLocation target : variant.getTargets()) {
                Block b = (Block)BuiltInRegistries.BLOCK.get(target);
                if (b instanceof IVariantBlock) {
                    IVariantBlock block = (IVariantBlock)b;
                    int max = block.requiredModels();
                    int rotatable = block.modelsRequiringRotation();
                    boolean isRotatable = block instanceof IRotatableBlock;
                    if (variant.getItemModel() != null) {
                        this.loadModel((ModelVariant)variant, (ResourceLocation)id, variant.getItemModel(), -1, block.getBlockID(), false);
                    } else {
                        this.loadModel((ModelVariant)variant, (ResourceLocation)id, block.getItemID().withPrefix("item/"), -1, block.getBlockID(), false);
                    }
                    if (variant.hasModels()) {
                        for (int i = 0; i < max; ++i) {
                            this.loadModel((ModelVariant)variant, (ResourceLocation)id, variant.getModels().get(i), i, block.getBlockID(), isRotatable && i < rotatable);
                        }
                        continue;
                    }
                    List<ResourceLocation> models = this.getDefaultModels(b, block);
                    max = Math.min(max, models.size());
                    for (int i = 0; i < max; ++i) {
                        this.loadModel((ModelVariant)variant, (ResourceLocation)id, models.get(i), i, block.getBlockID(), isRotatable && i < rotatable);
                    }
                    continue;
                }
                LightmansCurrency.LogWarning("Unable to set up variant '" + String.valueOf(id) + "' for target " + String.valueOf(target) + " as it is not a valid variant block.");
            }
        });
        profilerFiller.pop();
        profilerFiller.popPush("resolve_parents");
        this.topLevelModels.values().forEach(model -> model.resolveParents(this::getModel));
        profilerFiller.pop();
    }

    public void bakeModels(BiFunction<String, Material, TextureAtlasSprite> textureGetter) {
        this.topLevelModels.forEach((id, unbakedModel) -> {
            BakedModel bakedmodel = null;
            try {
                bakedmodel = new VariantModelBaker((ModelCacheKey)id, textureGetter).bakeUncached((UnbakedModel)unbakedModel, (ModelState)BlockModelRotation.X0_Y0);
            }
            catch (Exception e) {
                LightmansCurrency.LogWarning("Unable to bake model: '" + String.valueOf(id) + "'", e);
            }
            if (bakedmodel != null) {
                this.bakedTopLevelModels.put((ModelCacheKey)id, Objects.requireNonNull(bakedmodel));
            } else {
                LightmansCurrency.LogWarning("Variant Model " + String.valueOf(id) + " returned null during the baking process");
            }
        });
    }

    private List<ResourceLocation> getDefaultModels(Block block, IVariantBlock variantBlock) {
        ResourceLocation blockID = variantBlock.getBlockID();
        if (this.defaultModels.containsKey(blockID)) {
            return this.defaultModels.get(blockID);
        }
        List<ResourceLocation> defaultModels = VariantModelHelper.getDefaultModels(block, variantBlock, this.blockStates, BlockStateModelLoader::predicate);
        this.defaultModels.put(blockID, defaultModels);
        return defaultModels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnbakedModel getModel(ResourceLocation model) {
        if (this.unbakedCache.containsKey(model)) {
            return this.unbakedCache.get(model);
        }
        if (this.loadingStack.contains(model)) {
            throw new IllegalStateException("Circular reference while loading " + String.valueOf(model));
        }
        this.loadingStack.add(model);
        while (!this.loadingStack.isEmpty()) {
            ResourceLocation resourcelocation = this.loadingStack.iterator().next();
            try {
                if (this.unbakedCache.containsKey(resourcelocation)) continue;
                BlockModel unbakedmodel = this.loadBlockModel(resourcelocation);
                this.unbakedCache.put(resourcelocation, (UnbakedModel)unbakedmodel);
                this.loadingStack.addAll(unbakedmodel.getDependencies());
            }
            catch (Exception e) {
                this.unbakedCache.put(resourcelocation, this.missingModel);
            }
            finally {
                this.loadingStack.remove(resourcelocation);
            }
        }
        return this.unbakedCache.getOrDefault(model, this.missingModel);
    }

    private BlockModel loadBlockModel(ResourceLocation location) throws IOException {
        String s = location.getPath();
        if ("builtin/generated".equals(s)) {
            return ModelBakery.GENERATION_MARKER;
        }
        if ("builtin/entity".equals(s)) {
            return ModelBakery.BLOCK_ENTITY_MARKER;
        }
        if (s.startsWith("builtin/")) {
            String s1 = s.substring("builtin/".length());
            String s2 = BUILTIN_MODELS.get(s1);
            if (s2 == null) {
                throw new FileNotFoundException(location.toString());
            }
            StringReader reader = new StringReader(s2);
            BlockModel blockmodel1 = BlockModel.fromStream((Reader)reader);
            blockmodel1.name = location.toString();
            return blockmodel1;
        }
        ResourceLocation resourcelocation = ModelBakery.MODEL_LISTER.idToFile(location);
        BlockModel blockmodel = this.modelResources.get(resourcelocation);
        if (blockmodel == null) {
            throw new FileNotFoundException(resourcelocation.toString());
        }
        blockmodel.name = location.toString();
        return blockmodel;
    }

    private void loadModel(ModelVariant variant, ResourceLocation variantID, ResourceLocation model, int modelIndex, ResourceLocation target, boolean rotatable) {
        ResourceLocation cacheVariant = variantID;
        if (variant.hasTextureOverrides()) {
            ResourceLocation newModelID = VersionUtil.modResource(variantID.getNamespace(), "lc_model_variants/" + variantID.getPath() + "/" + modelIndex);
            VariantModelHelper.createCustomBlockModel(model, this.modelResources, variant.getTextureOverrides(), newModelID);
            model = newModelID;
        } else {
            cacheVariant = null;
        }
        if (rotatable) {
            for (int yRot = 0; yRot < 360; yRot += 90) {
                ModelCacheKey key = new ModelCacheKey(model, cacheVariant, yRot);
                VariantModelLocation modelLocation = VariantModelLocation.rotatable(variantID, target, modelIndex, yRot);
                UnbakedModel temp = this.topLevelModels.get(key);
                if (temp == null) {
                    temp = new MultiVariant((List)Lists.newArrayList((Object[])new Variant[]{new Variant(model, BlockModelRotation.by((int)0, (int)yRot).getRotation(), false, 1)}));
                    this.topLevelModels.put(key, temp);
                }
                this.keyToVariantLocation.put((Object)key, (Object)modelLocation);
            }
        } else {
            ModelCacheKey key = new ModelCacheKey(model, cacheVariant, 0);
            VariantModelLocation modelLocation = VariantModelLocation.basic(variantID, target, modelIndex);
            UnbakedModel temp = this.topLevelModels.get(key);
            if (temp == null) {
                ResourceLocation fileID = ModelBakery.MODEL_LISTER.idToFile(model);
                temp = this.getModel(model);
                this.topLevelModels.put(key, temp);
            }
            this.keyToVariantLocation.put((Object)key, (Object)modelLocation);
        }
    }

    private record ModelCacheKey(ResourceLocation model, @Nullable ResourceLocation variant, int yRot) {
    }

    @MethodsReturnNonnullByDefault
    @ParametersAreNonnullByDefault
    private class VariantModelBaker
    implements ModelBaker {
        private final Function<Material, TextureAtlasSprite> textureGetter = material -> (TextureAtlasSprite)textureGetter.apply(modelLocation.toString(), (Material)material);

        VariantModelBaker(ModelCacheKey modelLocation, BiFunction<String, Material, TextureAtlasSprite> textureGetter) {
        }

        public UnbakedModel getModel(ResourceLocation location) {
            return VariantModelBakery.this.getModel(location);
        }

        @Nullable
        public BakedModel bake(ResourceLocation location, ModelState transform) {
            return this.bake(location, transform, this.textureGetter);
        }

        @Nullable
        public UnbakedModel getTopLevelModel(ModelResourceLocation location) {
            return null;
        }

        @Nullable
        public BakedModel bake(ResourceLocation location, ModelState state, Function<Material, TextureAtlasSprite> sprites) {
            UnbakedModel model = this.getModel(location);
            if (model != null) {
                return this.bakeUncached(model, state, sprites);
            }
            return null;
        }

        @Nullable
        public BakedModel bakeUncached(UnbakedModel model, ModelState state) {
            return this.bakeUncached(model, state, this.textureGetter);
        }

        @Nullable
        public BakedModel bakeUncached(UnbakedModel model, ModelState state, Function<Material, TextureAtlasSprite> sprites) {
            BlockModel blockmodel;
            if (model instanceof BlockModel && (blockmodel = (BlockModel)model).getRootModel() == ModelBakery.GENERATION_MARKER) {
                return VariantModelBakery.this.ITEM_MODEL_GENERATOR.generateBlockModel(sprites, blockmodel).bake((ModelBaker)this, blockmodel, sprites, state, false);
            }
            return model.bake((ModelBaker)this, sprites, state);
        }

        public Function<Material, TextureAtlasSprite> getModelTextureGetter() {
            return this.textureGetter;
        }
    }
}

