/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.advancements.date;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.time.LocalDate;
import javax.annotation.Nonnull;
import net.minecraft.ResourceLocationException;
import net.minecraft.util.GsonHelper;

public final class DatePredicate {
    public final int month;
    public final int date;
    public static final Codec<DatePredicate> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("month").forGetter(dp -> dp.month), (App)Codec.INT.fieldOf("day").forGetter(dp -> dp.date)).apply((Applicative)builder, DatePredicate::new));

    public DatePredicate(int month, int date) {
        this.month = month;
        if (this.month < 1 || this.month > 12) {
            throw new IllegalArgumentException("Month must be between 1-12!");
        }
        this.date = date;
        if (this.date < 1 || this.date > 31) {
            throw new IllegalArgumentException("Day must be between 1-31!");
        }
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("month", (Number)this.month);
        json.addProperty("day", (Number)this.date);
        return json;
    }

    public static DatePredicate fromJson(@Nonnull JsonElement element) throws JsonSyntaxException, ResourceLocationException {
        JsonObject json = GsonHelper.convertToJsonObject((JsonElement)element, (String)"date data");
        return new DatePredicate(GsonHelper.getAsInt((JsonObject)json, (String)"month"), GsonHelper.getAsInt((JsonObject)json, (String)"day"));
    }

    private boolean isAfter(@Nonnull DatePredicate start) {
        if (this.month > start.month) {
            return true;
        }
        if (this.month == start.month) {
            return this.date >= start.date;
        }
        return false;
    }

    public boolean isAfter(@Nonnull LocalDate date) {
        if (this.month > date.getMonthValue()) {
            return true;
        }
        if (this.month == date.getMonthValue()) {
            return this.date >= date.getDayOfMonth();
        }
        return false;
    }

    public boolean isBefore(@Nonnull LocalDate date) {
        if (this.month < date.getMonthValue()) {
            return true;
        }
        if (this.month == date.getMonthValue()) {
            return this.date <= date.getDayOfMonth();
        }
        return false;
    }

    public static boolean isInRange(@Nonnull DatePredicate start, @Nonnull DatePredicate end) {
        return DatePredicate.isInRange(LocalDate.now(), start, end);
    }

    public static boolean isInRange(@Nonnull LocalDate date, @Nonnull DatePredicate start, @Nonnull DatePredicate end) {
        if (end.isAfter(start)) {
            return start.isBefore(date) && end.isAfter(date);
        }
        return start.isBefore(date) || end.isAfter(date);
    }
}

