/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity.variant;

import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public interface IVariantSupportingBlockEntity {
    @Nonnull
    public BlockState getBlockState();

    @Nullable
    public Level getLevel();

    @Nonnull
    public BlockPos getBlockPos();

    @Nullable
    public ResourceLocation getCurrentVariant();

    default public void setVariant(@Nullable ResourceLocation variant) {
        this.setVariant(variant, this.isVariantLocked());
    }

    public void setVariant(@Nullable ResourceLocation var1, boolean var2);

    public boolean isVariantLocked();

    public static void copyDataToItem(IVariantSupportingBlockEntity be, ItemStack item) {
        IVariantSupportingBlockEntity.copyDataToItem(be.getCurrentVariant(), be.isVariantLocked(), item);
    }

    public static void copyDataToItem(@Nullable ResourceLocation variant, boolean variantLocked, ItemStack item) {
        if (variant != null) {
            item.set(ModDataComponents.MODEL_VARIANT, (Object)variant);
        }
        if (variantLocked) {
            item.set(ModDataComponents.VARIANT_LOCK, (Object)Unit.INSTANCE);
        }
    }
}

