/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.data.types;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.data.CustomData;
import io.github.lightman314.lightmanscurrency.api.misc.data.CustomDataType;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.builtin.PlayerBankReference;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.common.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.util.LookupHelper;
import io.github.lightman314.lightmanscurrency.network.message.bank.CPacketSelectBankAccount;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BankDataCache
extends CustomData {
    public static final CustomDataType<BankDataCache> TYPE = new CustomDataType<BankDataCache>("lightmanscurrency_bank_data", BankDataCache::new);
    private final Map<UUID, BankDataEntry> playerBankData = new HashMap<UUID, BankDataEntry>();
    private int interestTick = 0;

    private BankDataCache() {
    }

    @Override
    public CustomDataType<?> getType() {
        return TYPE;
    }

    @Override
    public void save(CompoundTag tag, HolderLookup.Provider lookup) {
        ListTag bankData = new ListTag();
        this.playerBankData.forEach((player, data) -> {
            CompoundTag entry = new CompoundTag();
            entry.putUUID("Player", player);
            entry.put("BankAccount", (Tag)data.account.save(lookup));
            entry.put("LastSelected", (Tag)data.selected.save());
            bankData.add((Object)entry);
        });
        tag.put("PlayerBankData", (Tag)bankData);
        tag.putInt("InterestTick", this.interestTick);
    }

    @Override
    protected void load(CompoundTag tag, HolderLookup.Provider lookup) {
        ListTag bankData = tag.getList("PlayerBankData", 10);
        for (int i = 0; i < bankData.size(); ++i) {
            CompoundTag entry = bankData.getCompound(i);
            UUID player = entry.getUUID("Player");
            BankAccount bankAccount = this.loadBankAccount(player, entry.getCompound("BankAccount"), lookup);
            BankReference lastSelected = BankReference.load(entry.getCompound("LastSelected"));
            this.playerBankData.put(player, new BankDataEntry(bankAccount, lastSelected));
        }
        if (tag.contains("InterestTick")) {
            this.interestTick = tag.getInt("InterestTick");
        }
    }

    private BankAccount loadBankAccount(UUID player, CompoundTag compound, HolderLookup.Provider lookup) {
        BankAccount bankAccount = new BankAccount(() -> this.markAccountDirty(player), compound, lookup);
        try {
            bankAccount.setNotificationConsumer(BankAccount.generateNotificationAcceptor(player));
            bankAccount.updateOwnersName(PlayerReference.of(player, bankAccount.getOwnersName()).getName(false));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bankAccount;
    }

    private BankAccount generateBankAccount(UUID player) {
        BankAccount bankAccount = new BankAccount(() -> this.markAccountDirty(player));
        try {
            bankAccount.setNotificationConsumer(BankAccount.generateNotificationAcceptor(player));
            bankAccount.updateOwnersName(PlayerReference.of(player, bankAccount.getOwnersName()).getName(this.isClient()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bankAccount;
    }

    public List<BankReference> getPlayerBankAccounts() {
        ArrayList<BankReference> results = new ArrayList<BankReference>();
        for (UUID player : this.playerBankData.keySet()) {
            results.add(PlayerBankReference.of(player).flagAsClient(this));
        }
        return results;
    }

    public boolean hasAccount(UUID player) {
        return this.playerBankData.containsKey(player);
    }

    public BankAccount getAccount(Player player) {
        return this.getAccount(player.getUUID());
    }

    public BankAccount getAccount(UUID player) {
        if (this.playerBankData.containsKey(player)) {
            return this.playerBankData.get((Object)player).account;
        }
        BankAccount newAccount = this.generateBankAccount(player);
        this.playerBankData.put(player, new BankDataEntry(newAccount, PlayerBankReference.of(player).flagAsClient(this)));
        this.markAccountDirty(player);
        return newAccount;
    }

    public boolean deleteAccount(UUID player) {
        if (this.isClient()) {
            LightmansCurrency.LogWarning("Cannot delete a bank account from the logical client!");
            return false;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return false;
        }
        if (!this.playerBankData.containsKey(player)) {
            return false;
        }
        ServerPlayer onlinePlayer = server.getPlayerList().getPlayer(player);
        this.playerBankData.remove(player);
        if (onlinePlayer != null) {
            this.getAccount(player);
            this.syncSelectedAccount(onlinePlayer);
        } else {
            this.setChanged();
            this.sendSyncPacket(this.builder().setUUID("DeleteAccount", player));
        }
        return true;
    }

    public void markAccountDirty(UUID playerID) {
        this.setChanged();
        this.syncBankAccount(playerID);
    }

    private void syncBankAccount(UUID player) {
        this.syncBankAccount(player, null);
    }

    private void syncBankAccount(UUID player, @Nullable ServerPlayer target) {
        BankAccount account = this.getAccount(player);
        LazyPacketData.Builder packet = this.builder().setUUID("UpdateAccount", player).setCompound("Account", account.save((HolderLookup.Provider)LookupHelper.getRegistryAccess()));
        if (target == null) {
            this.sendSyncPacket(packet);
        } else {
            this.sendSyncPacket(packet, target);
        }
    }

    public BankReference getSelectedAccount(Player player) {
        if (this.playerBankData.containsKey(player.getUUID())) {
            BankReference account = this.playerBankData.get((Object)player.getUUID()).selected;
            if (!account.allowedAccess(player)) {
                LightmansCurrency.LogInfo(player.getName().getString() + " is no longer allowed to access their selected bank account. Switching back to their personal account.");
                account = PlayerBankReference.of(player).flagAsClient(this);
                this.setSelectedAccount(player, account);
            }
            return account;
        }
        BankReference account = PlayerBankReference.of(player).flagAsClient(this);
        this.setSelectedAccount(player, account);
        return account;
    }

    public void setSelectedAccount(Player player, BankReference account) {
        if (account == null) {
            return;
        }
        if (this.isClient()) {
            if (!LightmansCurrency.getProxy().isSelf(player)) {
                return;
            }
            new CPacketSelectBankAccount(account).send();
            return;
        }
        if (!account.allowedAccess(player)) {
            LightmansCurrency.LogInfo("Player does not have access to the selected account. Canceling selection.");
            return;
        }
        BankDataEntry data = this.playerBankData.get(player.getUUID());
        if (data == null) {
            data = new BankDataEntry(this.generateBankAccount(player.getUUID()), null);
            this.syncBankAccount(player.getUUID());
        }
        data.selected = account;
        this.setChanged();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            this.syncSelectedAccount(sp);
        }
    }

    private void syncSelectedAccount(ServerPlayer player) {
        this.sendSyncPacket(this.builder().setUUID("UpdateSelected", player.getUUID()).setCompound("Selected", this.getSelectedAccount((Player)player).save()), player);
    }

    @Override
    protected void parseSyncPacket(LazyPacketData message, HolderLookup.Provider lookup) {
        BankDataEntry data;
        UUID account;
        if (message.contains("ClearAccounts")) {
            this.playerBankData.clear();
        }
        if (message.contains("DeleteAccount")) {
            this.playerBankData.remove(message.getUUID("DeleteAccount"));
        }
        if (message.contains("UpdateAccount")) {
            account = message.getUUID("UpdateAccount");
            BankAccount ba = this.loadBankAccount(account, message.getNBT("Account"), (HolderLookup.Provider)LookupHelper.getRegistryAccess()).flagAsClient(this);
            data = this.playerBankData.containsKey(account) ? this.playerBankData.get(account) : new BankDataEntry(null, PlayerBankReference.of(account).flagAsClient(this));
            data.account = ba;
            this.playerBankData.put(account, data);
        }
        if (message.contains("UpdateSelected")) {
            account = message.getUUID("UpdateSelected");
            BankReference selected = BankReference.load(message.getNBT("Selected")).flagAsClient(this);
            data = this.playerBankData.containsKey(account) ? this.playerBankData.get(account) : new BankDataEntry(this.generateBankAccount(account), null);
            data.selected = selected;
            this.playerBankData.put(account, data);
        }
    }

    @Override
    public void onPlayerJoin(ServerPlayer player) {
        for (UUID p : this.playerBankData.keySet()) {
            this.syncBankAccount(p, player);
        }
        this.getAccount((Player)player);
        this.syncSelectedAccount(player);
    }

    public int interestTick() {
        this.setChanged();
        return this.interestTick++;
    }

    public void resetInterestTick() {
        this.interestTick = 0;
        this.setChanged();
    }

    private static class BankDataEntry {
        BankAccount account;
        BankReference selected;

        BankDataEntry(BankAccount account, BankReference selected) {
            this.account = account;
            this.selected = selected;
        }
    }
}

