/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;

public class ChocolateCoinItem
extends Item {
    public ChocolateCoinItem(MobEffectInstance ... effects) {
        this(0.0f, effects);
    }

    public ChocolateCoinItem(float healing, MobEffectInstance ... effects) {
        this(new Item.Properties(), healing, effects);
    }

    public ChocolateCoinItem(Item.Properties properties, MobEffectInstance ... effects) {
        this(properties, 0.0f, effects);
    }

    public ChocolateCoinItem(Item.Properties properties, float healing, MobEffectInstance ... effects) {
        super(properties.food(new FoodProperties.Builder().alwaysEdible().nutrition(2).saturationModifier(0.1f).build()).component(ModDataComponents.CHOCOLATE_HEALING, (Object)Float.valueOf(healing)).component(ModDataComponents.CHOCOLATE_EFFECTS, (Object)ImmutableList.copyOf((Object[])effects)));
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        if (context.registries() == null) {
            return;
        }
        if (((Boolean)LCConfig.SERVER.chocolateCoinEffects.get()).booleanValue()) {
            List effects;
            float healing = ((Float)stack.getOrDefault(ModDataComponents.CHOCOLATE_HEALING, (Object)Float.valueOf(0.0f))).floatValue();
            if (healing > 0.0f) {
                tooltip.add((Component)LCText.TOOLTIP_HEALING.get((int)healing).withStyle(ChatFormatting.BLUE));
            }
            if (!(effects = (List)stack.getOrDefault(ModDataComponents.CHOCOLATE_EFFECTS, (Object)ImmutableList.of())).isEmpty()) {
                new PotionContents(Optional.empty(), Optional.empty(), effects).addPotionTooltip(tooltip::add, 1.0f, context.tickRate());
            }
        }
    }

    @Nonnull
    public ItemStack finishUsingItem(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull LivingEntity entity) {
        if (((Boolean)LCConfig.SERVER.chocolateCoinEffects.get()).booleanValue()) {
            float healing = ((Float)stack.getOrDefault(ModDataComponents.CHOCOLATE_HEALING, (Object)Float.valueOf(0.0f))).floatValue();
            if (healing > 0.0f) {
                entity.heal(healing);
            }
            List effects = (List)stack.getOrDefault(ModDataComponents.CHOCOLATE_EFFECTS, (Object)ImmutableList.of());
            for (MobEffectInstance effect : effects) {
                entity.addEffect(new MobEffectInstance(effect));
            }
        }
        return super.finishUsingItem(stack, level, entity);
    }
}

