/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items.cards;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.common.util.TooltipHelper;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class PrepaidCardItem
extends Item {
    public PrepaidCardItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        MoneyValue value = (MoneyValue)stack.getOrDefault(ModDataComponents.MONEY_VALUE, (Object)MoneyValue.empty());
        tooltip.add((Component)LCText.GUI_BANK_BALANCE.get(value.getText(LCText.GUI_MONEY_STORAGE_EMPTY.get(new Object[0]))).withStyle(ChatFormatting.GRAY));
        tooltip.addAll(TooltipHelper.splitTooltips((Component)LCText.TOOLTIP_PAYMENT_CARD_USAGE.get(new Object[0]), ChatFormatting.GRAY));
        tooltip.add((Component)LCText.TOOLTIP_PREPAID_CARD_DELETE_WARNING.getWithStyle(ChatFormatting.GRAY));
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public void inventoryTick(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull Entity player, int slot, boolean isSelected) {
        if (((MoneyValue)stack.getOrDefault(ModDataComponents.MONEY_VALUE, (Object)MoneyValue.empty())).isEmpty()) {
            stack.setCount(0);
        }
    }
}

