/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.loot.entries;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lightman314.lightmanscurrency.common.core.ModLootPoolEntryTypes;
import io.github.lightman314.lightmanscurrency.common.loot.ConfigItemTier;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ConfigLoot
extends LootPoolSingletonContainer {
    public static final MapCodec<ConfigLoot> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.INT.fieldOf("tier").forGetter(l -> l.tier.tier)).and(ConfigLoot.singletonFields((RecordCodecBuilder.Instance)builder)).apply((Applicative)builder, ConfigLoot::new));
    private final ConfigItemTier tier;

    protected ConfigLoot(int tier, int weight, int quality, List<LootItemCondition> conditions, List<LootItemFunction> functions) {
        this(ConfigItemTier.get(tier), weight, quality, conditions, functions);
    }

    protected ConfigLoot(ConfigItemTier tier, int weight, int quality, List<LootItemCondition> conditions, List<LootItemFunction> functions) {
        super(weight, quality, conditions, functions);
        this.tier = tier;
    }

    protected void createItemStack(@Nonnull Consumer<ItemStack> consumer, @Nonnull LootContext context) {
        consumer.accept(new ItemStack((ItemLike)this.tier.getItem()));
    }

    @Nonnull
    public LootPoolEntryType getType() {
        return ModLootPoolEntryTypes.LOOT_TIER_TYPE.get();
    }

    public static LootPoolSingletonContainer.Builder<?> lootTableTier(@Nonnull ConfigItemTier tier) {
        return ConfigLoot.simpleBuilder((p_79583_, p_79584_, p_79585_, p_79586_) -> new ConfigLoot(tier, p_79583_, p_79584_, (List<LootItemCondition>)p_79585_, (List<LootItemFunction>)p_79586_));
    }
}

