/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.common.blockentity.TicketStationBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.crafting.RecipeValidator;
import io.github.lightman314.lightmanscurrency.common.crafting.TicketStationRecipe;
import io.github.lightman314.lightmanscurrency.common.crafting.input.TicketStationRecipeInput;
import io.github.lightman314.lightmanscurrency.common.menus.LazyMessageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.slots.OutputSlot;
import io.github.lightman314.lightmanscurrency.common.menus.slots.ticket.TicketMaterialSlot;
import io.github.lightman314.lightmanscurrency.common.menus.slots.ticket.TicketModifierSlot;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.BlockEntityValidator;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;

public class TicketStationMenu
extends LazyMessageMenu {
    private final Container output = new SimpleContainer(1);
    private String code = "";
    private int durability = 0;
    public final TicketStationBlockEntity blockEntity;

    public TicketStationRecipe.ExtraData getExtraData() {
        return new TicketStationRecipe.ExtraData(this.code, this.durability);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
        if (this.isClient()) {
            this.SendMessage(this.builder().setString("ChangeCode", code));
        }
    }

    public int getDurability() {
        return this.durability;
    }

    public void setDurability(int durability) {
        this.durability = durability;
        if (this.isClient()) {
            this.SendMessage(this.builder().setInt("ChangeDurability", durability));
        }
    }

    public static List<RecipeHolder<TicketStationRecipe>> getAllRecipes(@Nonnull Level level) {
        return RecipeValidator.getTicketStationRecipes(level);
    }

    public List<RecipeHolder<TicketStationRecipe>> getAllRecipes() {
        return TicketStationMenu.getAllRecipes(this.blockEntity.getLevel());
    }

    public List<TicketStationRecipe> getRecipeList() {
        return RecipeValidator.getTicketStationRecipeList(this.blockEntity.getLevel());
    }

    public RecipeHolder<TicketStationRecipe> getRecipe(@Nonnull ResourceLocation recipeID) {
        for (RecipeHolder<TicketStationRecipe> recipe : this.getAllRecipes()) {
            if (!recipe.id().equals((Object)recipeID)) continue;
            return recipe;
        }
        return null;
    }

    public TicketStationMenu(int windowId, Inventory inventory, TicketStationBlockEntity blockEntity) {
        super(ModMenus.TICKET_MACHINE.get(), windowId, inventory);
        this.blockEntity = blockEntity;
        this.addValidator(BlockEntityValidator.of(this.blockEntity));
        this.addSlot(new TicketModifierSlot(this, this.blockEntity.getStorage(), 0, 20, 21));
        this.addSlot(new TicketMaterialSlot(this, this.blockEntity.getStorage(), 1, 56, 21));
        this.addSlot(new OutputSlot(this.output, 0, 116, 21));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)inventory, x + y * 9 + 9, 8 + x * 18, 76 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)inventory, x, 8 + x * 18, 134));
        }
    }

    public void removed(@Nonnull Player playerIn) {
        super.removed(playerIn);
        this.clearContainer(playerIn, this.output);
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player player, int index) {
        ItemStack clickedStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            clickedStack = slotStack.copy();
            int totalSize = this.blockEntity.getStorage().getContainerSize() + this.output.getContainerSize();
            if (index < totalSize ? !this.moveItemStackTo(slotStack, totalSize, this.slots.size(), true) : !this.moveItemStackTo(slotStack, 0, this.blockEntity.getStorage().getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return clickedStack;
    }

    public boolean validInputs() {
        TicketStationRecipeInput input = this.blockEntity.getRecipeInput(this.getExtraData());
        return this.getAllRecipes().stream().anyMatch(r -> ((TicketStationRecipe)r.value()).matches(input, this.blockEntity.getLevel()) && ((TicketStationRecipe)r.value()).validData(this.getExtraData()));
    }

    public boolean roomForOutput(TicketStationRecipe recipe) {
        if (recipe == null) {
            return false;
        }
        ItemStack outputStack = this.output.getItem(0);
        if (outputStack.isEmpty()) {
            return true;
        }
        return InventoryUtil.ItemMatches(recipe.peekAtResult(this.blockEntity.getStorage(), this.getExtraData()), outputStack) && outputStack.getMaxStackSize() > outputStack.getCount();
    }

    public void craftTickets(boolean fullStack, @Nonnull ResourceLocation recipeID) {
        RecipeHolder<TicketStationRecipe> holder = this.getRecipe(recipeID);
        if (holder == null) {
            return;
        }
        TicketStationRecipe recipe = (TicketStationRecipe)holder.value();
        if (!recipe.matches(this.blockEntity.getRecipeInput(this.getExtraData()), this.blockEntity.getLevel()) || !recipe.validData(this.getExtraData())) {
            return;
        }
        if (!this.roomForOutput(recipe)) {
            LightmansCurrency.LogDebug("No room for Ticket Machine outputs. Cannot craft tickets.");
            return;
        }
        int amountToCraft = 1;
        if (fullStack) {
            amountToCraft = this.output.getMaxStackSize();
        }
        for (int i = 0; i < amountToCraft; ++i) {
            if (!this.assemble(recipe)) continue;
            return;
        }
    }

    private boolean assemble(@Nonnull TicketStationRecipe recipe) {
        ItemStack result;
        TicketStationRecipeInput input = this.blockEntity.getRecipeInput(this.getExtraData());
        if (this.roomForOutput(recipe) && recipe.matches(input, this.blockEntity.getLevel()) && !(result = recipe.assemble(input, (HolderLookup.Provider)this.blockEntity.getLevel().registryAccess())).isEmpty() && InventoryUtil.PutItemStack(this.output, result)) {
            if (recipe.consumeModifier()) {
                this.blockEntity.getStorage().removeItem(0, 1);
            }
            this.blockEntity.getStorage().removeItem(1, 1);
            return false;
        }
        return true;
    }

    public void SendCraftTicketsMessage(boolean fullStack, ResourceLocation recipe) {
        this.SendMessageToServer(this.builder().setBoolean("CraftTickets", fullStack).setResourceLocation("Recipe", recipe));
    }

    @Override
    public void HandleMessage(@Nonnull LazyPacketData message) {
        if (message.contains("CraftTickets")) {
            this.craftTickets(message.getBoolean("CraftTickets"), message.getResourceLocation("Recipe"));
        }
        if (message.contains("ChangeCode")) {
            this.setCode(message.getString("ChangeCode"));
        }
        if (message.contains("ChangeDurability")) {
            this.setDurability(message.getInt("ChangeDurability"));
        }
    }
}

