/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.traderstorage.command;

import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.command.CommandTradeEditClientTab;
import io.github.lightman314.lightmanscurrency.common.traders.commands.CommandTrader;
import io.github.lightman314.lightmanscurrency.common.traders.commands.tradedata.CommandTrade;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class CommandTradeEditTab
extends TraderStorageTab {
    private int tradeIndex = -1;

    public CommandTradeEditTab(ITraderStorageMenu menu) {
        super(menu);
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(@Nonnull Object screen) {
        return new CommandTradeEditClientTab(screen, this);
    }

    @Override
    public boolean canOpen(Player player) {
        return ((ITraderStorageMenu)this.menu).hasPermission("editTrades");
    }

    public int getTradeIndex() {
        return this.tradeIndex;
    }

    public CommandTrade getTrade() {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof CommandTrader) {
            CommandTrader trader = (CommandTrader)traderData;
            if (this.tradeIndex >= trader.getTradeCount() || this.tradeIndex < 0) {
                ((ITraderStorageMenu)this.menu).ChangeTab(0);
                return null;
            }
            return trader.getTrade(this.tradeIndex);
        }
        return null;
    }

    public void setCommand(String newCommand) {
        CommandTrade trade = this.getTrade();
        if (trade != null) {
            trade.setCommand(newCommand);
            ((ITraderStorageMenu)this.menu).getTrader().markTradesDirty();
            if (this.isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setString("NewCommand", newCommand));
            }
        }
    }

    public void setDescription(String newDescription) {
        CommandTrade trade = this.getTrade();
        if (trade != null) {
            trade.setDescription(newDescription);
            ((ITraderStorageMenu)this.menu).getTrader().markTradesDirty();
            if (this.isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setString("NewDescription", newDescription));
            }
        }
    }

    public void setTooltip(String newTooltip) {
        CommandTrade trade = this.getTrade();
        if (trade != null) {
            trade.setTooltip(newTooltip);
            ((ITraderStorageMenu)this.menu).getTrader().markTradesDirty();
            if (this.isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setString("NewTooltip", newTooltip));
            }
        }
    }

    public void setPrice(MoneyValue price) {
        CommandTrade trade = this.getTrade();
        if (trade != null) {
            trade.setCost(price);
            ((ITraderStorageMenu)this.menu).getTrader().markTradesDirty();
            if (this.isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setMoneyValue("NewPrice", price));
            }
        }
    }

    @Override
    public void OpenMessage(@Nonnull LazyPacketData message) {
        if (message.contains("TradeIndex")) {
            this.tradeIndex = message.getInt("TradeIndex");
        }
    }

    @Override
    public void receiveMessage(LazyPacketData message) {
        if (message.contains("NewCommand")) {
            this.setCommand(message.getString("NewCommand"));
        }
        if (message.contains("NewDescription")) {
            this.setDescription(message.getString("NewDescription"));
        }
        if (message.contains("NewTooltip")) {
            this.setTooltip(message.getString("NewTooltip"));
        }
        if (message.contains("NewPrice")) {
            this.setPrice(message.getMoneyValue("NewPrice"));
        }
    }
}

