/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.categories;

import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.ItemIcon;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategoryType;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TraderCategory
extends NotificationCategory {
    public static final NotificationCategoryType<TraderCategory> TYPE = new NotificationCategoryType<TraderCategory>(VersionUtil.lcResource("trader"), TraderCategory::new);
    private final Item trader;
    private final long traderID;
    private final Component traderName;
    private final IconData traderIcon;

    @Deprecated(since="2.3.0.0")
    public TraderCategory(ItemLike trader, Component traderName, long traderID) {
        this(trader, traderName, traderID, IconData.Null());
    }

    public TraderCategory(ItemLike trader, Component traderName, long traderID, IconData icon) {
        this.trader = trader.asItem();
        this.traderName = traderName;
        this.traderID = traderID;
        this.traderIcon = icon == null ? IconData.Null() : icon;
    }

    public TraderCategory(CompoundTag compound, HolderLookup.Provider lookup) {
        this.trader = compound.contains("Icon") ? (Item)BuiltInRegistries.ITEM.get(VersionUtil.parseResource(compound.getString("Icon"))) : ModItems.TRADING_CORE.get();
        this.traderName = compound.contains("TraderName") ? Component.Serializer.fromJson((String)compound.getString("TraderName"), (HolderLookup.Provider)lookup) : Component.translatable((String)"gui.lightmanscurrency.universaltrader.default");
        this.traderID = compound.contains("TraderID") ? compound.getLong("TraderID") : -1L;
        this.traderIcon = compound.contains("CustomIcon") ? IconData.load(compound.getCompound("CustomIcon"), lookup) : IconData.Null();
    }

    @Override
    public IconData getIcon() {
        if (!this.traderIcon.isNull()) {
            return this.traderIcon;
        }
        return ItemIcon.ofItem((ItemLike)this.trader);
    }

    @Override
    public Component getName() {
        return this.traderName;
    }

    public NotificationCategoryType<TraderCategory> getType() {
        return TYPE;
    }

    @Override
    public boolean matches(NotificationCategory other) {
        if (other instanceof TraderCategory) {
            TraderCategory otherTrader = (TraderCategory)other;
            if (this.traderID >= 0L) {
                if (this.traderID == otherTrader.traderID) {
                    return true;
                }
            } else {
                return false;
            }
            return this.traderName.getString().contentEquals(otherTrader.traderName.getString()) && this.trader.equals(otherTrader.trader);
        }
        return false;
    }

    @Override
    public void saveAdditional(CompoundTag compound, HolderLookup.Provider lookup) {
        compound.putString("Icon", BuiltInRegistries.ITEM.getKey((Object)this.trader).toString());
        compound.putString("TraderName", Component.Serializer.toJson((Component)this.traderName, (HolderLookup.Provider)lookup));
        compound.putLong("TraderID", this.traderID);
        if (!this.traderIcon.isNull()) {
            compound.put("CustomIcon", (Tag)this.traderIcon.save(lookup));
        }
    }
}

