/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.settings;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.api.notifications.SingleLineNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.NullCategory;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class ChangeSettingNotification
extends SingleLineNotification {
    public static final NotificationType<Advanced> ADVANCED_TYPE = new NotificationType<Advanced>(VersionUtil.lcResource("change_settings_advanced"), ChangeSettingNotification::createAdvanced);
    public static final NotificationType<Simple> SIMPLE_TYPE = new NotificationType<Simple>(VersionUtil.lcResource("change_settings_simple"), ChangeSettingNotification::createSimple);
    public static final NotificationType<Dumb> DUMB_TYPE = new NotificationType<Dumb>(VersionUtil.lcResource("change_settings_dumb"), ChangeSettingNotification::createDumb);
    protected PlayerReference player;
    protected Component setting;

    protected ChangeSettingNotification(PlayerReference player, Component setting) {
        this.player = player;
        this.setting = setting;
    }

    protected ChangeSettingNotification() {
    }

    @Nullable
    public static ChangeSettingNotification dumb(@Nullable PlayerReference player, Component setting) {
        return player == null ? null : new Dumb(player, setting);
    }

    @Nullable
    public static ChangeSettingNotification simple(@Nullable PlayerReference player, Component setting, int newValue) {
        return ChangeSettingNotification.simple(player, setting, String.valueOf(newValue));
    }

    @Nullable
    public static ChangeSettingNotification simple(@Nullable PlayerReference player, Component setting, boolean newValue) {
        return ChangeSettingNotification.simple(player, setting, (Component)LCText.GUI_SETTINGS_VALUE_TRUE_FALSE.get(newValue).get(new Object[0]));
    }

    @Nullable
    public static ChangeSettingNotification simple(@Nullable PlayerReference player, Component setting, String newValue) {
        return ChangeSettingNotification.simple(player, setting, (Component)EasyText.literal(newValue));
    }

    @Nullable
    public static ChangeSettingNotification simple(@Nullable PlayerReference player, Component setting, Component newValue) {
        return player == null ? null : new Simple(player, setting, newValue);
    }

    @Nullable
    public static ChangeSettingNotification advanced(@Nullable PlayerReference player, Component setting, int newValue, int oldValue) {
        return ChangeSettingNotification.advanced(player, setting, String.valueOf(newValue), String.valueOf(oldValue));
    }

    public static ChangeSettingNotification advanced(@Nullable PlayerReference player, Component setting, String newValue, String oldValue) {
        return ChangeSettingNotification.advanced(player, setting, (Component)EasyText.literal(newValue), (Component)EasyText.literal(oldValue));
    }

    public static ChangeSettingNotification advanced(@Nullable PlayerReference player, Component setting, Component newValue, Component oldValue) {
        return player == null ? null : new Advanced(player, setting, newValue, oldValue);
    }

    @Override
    public NotificationCategory getCategory() {
        return NullCategory.INSTANCE;
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider lookup) {
        compound.put("Player", (Tag)this.player.save());
        compound.putString("Setting", Component.Serializer.toJson((Component)this.setting, (HolderLookup.Provider)lookup));
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider lookup) {
        this.player = PlayerReference.load(compound.getCompound("Player"));
        this.setting = EasyText.loadComponentOrString(compound.getString("Setting"), lookup);
    }

    private static Advanced createAdvanced() {
        return new Advanced();
    }

    private static Simple createSimple() {
        return new Simple();
    }

    private static Dumb createDumb() {
        return new Dumb();
    }

    public static class Dumb
    extends ChangeSettingNotification {
        private Dumb() {
        }

        private Dumb(PlayerReference player, Component setting) {
            super(player, setting);
        }

        @Override
        protected Component getMessage() {
            return LCText.NOTIFICATION_SETTINGS_CHANGE_DUMB.get(this.player.getName(this.isClient()), this.setting);
        }

        @Override
        protected NotificationType<?> getType() {
            return DUMB_TYPE;
        }

        @Override
        protected boolean canMerge(Notification other) {
            if (other instanceof Dumb) {
                Dumb d = (Dumb)other;
                return d.player.equals(this.player) && d.setting.equals((Object)this.setting);
            }
            return false;
        }
    }

    public static class Simple
    extends ChangeSettingNotification {
        Component newValue;

        private Simple() {
        }

        private Simple(PlayerReference player, Component setting, Component newValue) {
            super(player, setting);
            this.newValue = newValue;
        }

        protected NotificationType<Simple> getType() {
            return SIMPLE_TYPE;
        }

        @Override
        public Component getMessage() {
            return LCText.NOTIFICATION_SETTINGS_CHANGE_SIMPLE.get(this.player.getName(this.isClient()), this.setting, this.newValue);
        }

        @Override
        protected void saveAdditional(CompoundTag compound, HolderLookup.Provider lookup) {
            super.saveAdditional(compound, lookup);
            compound.putString("NewValue", Component.Serializer.toJson((Component)this.newValue, (HolderLookup.Provider)lookup));
        }

        @Override
        protected void loadAdditional(CompoundTag compound, HolderLookup.Provider lookup) {
            super.loadAdditional(compound, lookup);
            this.newValue = EasyText.loadComponentOrString(compound.getString("NewValue"), lookup);
        }

        @Override
        protected boolean canMerge(Notification other) {
            if (other instanceof Simple) {
                Simple n = (Simple)other;
                return n.player.is(this.player) && n.setting.equals((Object)this.setting) && n.newValue.equals((Object)this.newValue);
            }
            return false;
        }
    }

    public static class Advanced
    extends ChangeSettingNotification {
        Component newValue;
        Component oldValue;

        private Advanced() {
        }

        private Advanced(PlayerReference player, Component setting, Component newValue, Component oldValue) {
            super(player, setting);
            this.newValue = newValue;
            this.oldValue = oldValue;
        }

        protected NotificationType<Advanced> getType() {
            return ADVANCED_TYPE;
        }

        @Override
        public Component getMessage() {
            return LCText.NOTIFICATION_SETTINGS_CHANGE_ADVANCED.get(this.player.getName(this.isClient()), this.setting, this.oldValue, this.newValue);
        }

        @Override
        protected void saveAdditional(CompoundTag compound, HolderLookup.Provider lookup) {
            super.saveAdditional(compound, lookup);
            compound.putString("NewValue", Component.Serializer.toJson((Component)this.newValue, (HolderLookup.Provider)lookup));
            compound.putString("OldValue", Component.Serializer.toJson((Component)this.oldValue, (HolderLookup.Provider)lookup));
        }

        @Override
        protected void loadAdditional(CompoundTag compound, HolderLookup.Provider lookup) {
            super.loadAdditional(compound, lookup);
            this.newValue = EasyText.loadComponentOrString(compound.getString("NewValue"), lookup);
            this.oldValue = EasyText.loadComponentOrString(compound.getString("OldValue"), lookup);
        }

        @Override
        protected boolean canMerge(Notification other) {
            if (other instanceof Advanced) {
                Advanced n = (Advanced)other;
                return n.player.is(this.player) && n.setting.equals((Object)this.setting) && n.newValue.equals((Object)this.newValue) && n.oldValue.equals((Object)this.oldValue);
            }
            return false;
        }
    }
}

