/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.item;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.common.blockentity.handler.ICanCopy;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Range;

public class TraderItemStorage
implements IItemHandler,
ICanCopy<TraderItemStorage> {
    private final ITraderItemFilter filter;
    private final List<ItemStack> storage = new ArrayList<ItemStack>();

    public TraderItemStorage(@Nonnull ITraderItemFilter filter) {
        this.filter = filter;
    }

    public CompoundTag save(@Nonnull CompoundTag compound, @Nonnull String tag, @Nonnull HolderLookup.Provider lookup) {
        ListTag list = new ListTag();
        for (ItemStack item : this.storage) {
            if (item.isEmpty()) continue;
            list.add((Object)InventoryUtil.saveItemNoLimits(item, lookup));
        }
        compound.put(tag, (Tag)list);
        return compound;
    }

    public void load(@Nonnull CompoundTag compound, @Nonnull String tag, @Nonnull HolderLookup.Provider lookup) {
        if (compound.contains(tag, 9)) {
            ListTag list = compound.getList(tag, 10);
            this.storage.clear();
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag itemTag = list.getCompound(i);
                ItemStack item = InventoryUtil.loadItemNoLimits(itemTag, lookup);
                if (item.isEmpty()) continue;
                this.storage.add(item);
            }
        }
    }

    public List<ItemStack> getContents() {
        return this.storage;
    }

    public List<ItemStack> getSplitContents() {
        ArrayList<ItemStack> contents = new ArrayList<ItemStack>();
        for (ItemStack s : this.storage) {
            ItemStack stack = s.copy();
            int maxCount = stack.getMaxStackSize();
            while (stack.getCount() > maxCount) {
                contents.add(stack.split(maxCount));
            }
            contents.add(stack);
        }
        return contents;
    }

    public int getSlotCount() {
        return this.storage.size();
    }

    public boolean hasItem(ItemStack item) {
        for (ItemStack stack : this.storage) {
            if (!InventoryUtil.ItemMatches(stack, item)) continue;
            return stack.getCount() >= item.getCount();
        }
        return false;
    }

    public boolean hasItems(ItemStack ... items) {
        for (ItemStack item : InventoryUtil.combineQueryItems(items)) {
            if (this.hasItem(item)) continue;
            return false;
        }
        return true;
    }

    public boolean allowItem(ItemStack item) {
        if (item.isEmpty()) {
            return false;
        }
        return this.filter.isItemRelevant(item);
    }

    public int getMaxAmount() {
        return this.filter.getStorageStackLimit();
    }

    public int getItemCount(ItemStack item) {
        for (ItemStack stack : this.storage) {
            if (!InventoryUtil.ItemMatches(item, stack)) continue;
            return stack.getCount();
        }
        return 0;
    }

    public int getItemCount(Predicate<ItemStack> filter) {
        int count = 0;
        for (ItemStack stack : this.storage) {
            if (!filter.test(stack)) continue;
            count += stack.getCount();
        }
        return count;
    }

    public int getItemTagCount(TagKey<Item> itemTag, Item ... blacklistItems) {
        ArrayList blacklist = Lists.newArrayList((Object[])blacklistItems);
        int count = 0;
        for (ItemStack stack : this.storage) {
            if (!InventoryUtil.ItemHasTag(stack, itemTag) || blacklist.contains(stack.getItem())) continue;
            count += stack.getCount();
        }
        return count;
    }

    public @Range(to=0L, from=0x7FFFFFFFL) int getFittableAmount(ItemStack item) {
        if (!this.allowItem(item)) {
            return 0;
        }
        return Math.max(0, this.getMaxAmount() - this.getItemCount(item));
    }

    public boolean canFitItem(ItemStack item) {
        return this.getFittableAmount(item) >= item.getCount();
    }

    public boolean canFitItems(ItemStack ... items) {
        for (ItemStack item : InventoryUtil.combineQueryItems(items)) {
            if (this.canFitItem(item)) continue;
            return false;
        }
        return true;
    }

    public boolean canFitItems(List<ItemStack> items) {
        if (items == null) {
            return true;
        }
        for (ItemStack item : InventoryUtil.combineQueryItems(items)) {
            if (this.canFitItem(item)) continue;
            return false;
        }
        return true;
    }

    public boolean addItem(ItemStack item) {
        if (!this.canFitItem(item)) {
            return false;
        }
        this.forceAddItem(item);
        return true;
    }

    public void tryAddItem(ItemStack item) {
        if (!this.allowItem(item)) {
            return;
        }
        int amountToAdd = Math.min(item.getCount(), this.getFittableAmount(item));
        if (amountToAdd > 0) {
            ItemStack addStack = item.split(amountToAdd);
            this.forceAddItem(addStack);
        }
    }

    public void forceAddItem(ItemStack item) {
        if (item.isEmpty()) {
            return;
        }
        for (ItemStack stack : this.storage) {
            if (!InventoryUtil.ItemMatches(stack, item)) continue;
            stack.grow(item.getCount());
            return;
        }
        this.storage.add(item.copy());
    }

    public ItemStack removeItem(ItemStack item) {
        if (!this.hasItem(item)) {
            return ItemStack.EMPTY;
        }
        for (int i = 0; i < this.storage.size(); ++i) {
            ItemStack stack = this.storage.get(i);
            if (!InventoryUtil.ItemMatches(item, stack)) continue;
            int amountToRemove = Math.min(item.getCount(), item.getMaxStackSize());
            ItemStack output = stack.split(amountToRemove);
            if (stack.isEmpty()) {
                this.storage.remove(i);
            }
            return output;
        }
        return ItemStack.EMPTY;
    }

    public void removeItemTagCount(TagKey<Item> itemTag, int count, List<ItemStack> ignoreIfPossible, Item ... blacklistItems) {
        ArrayList blacklist = Lists.newArrayList((Object[])blacklistItems);
        this.removeItemCount(s -> InventoryUtil.ItemHasTag(s, itemTag), count, ignoreIfPossible, s -> blacklist.stream().anyMatch(b -> s.getItem() == b));
    }

    public void removeItemCount(Predicate<ItemStack> filter, int count, List<ItemStack> ignoreIfPossible, Predicate<ItemStack> blacklist) {
        int amountToTake;
        ItemStack stack;
        int i;
        for (i = 0; i < this.storage.size() && count > 0; ++i) {
            stack = this.storage.get(i);
            if (!filter.test(stack) || blacklist.test(stack) || TraderItemStorage.ListContains(ignoreIfPossible, stack)) continue;
            amountToTake = Math.min(count, stack.getCount());
            count -= amountToTake;
            stack.shrink(amountToTake);
            if (!stack.isEmpty()) continue;
            this.storage.remove(i);
            --i;
        }
        for (i = 0; i < this.storage.size() && count > 0; ++i) {
            stack = this.storage.get(i);
            if (!filter.test(stack) || blacklist.test(stack)) continue;
            amountToTake = Math.min(count, stack.getCount());
            count -= amountToTake;
            stack.shrink(amountToTake);
            if (!stack.isEmpty()) continue;
            this.storage.remove(i);
            --i;
        }
    }

    private static boolean ListContains(List<ItemStack> list, ItemStack stack) {
        for (ItemStack item : list) {
            if (!InventoryUtil.ItemMatches(item, stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TraderItemStorage copy() {
        TraderItemStorage copy = new TraderItemStorage(this.filter);
        for (ItemStack stack : this.storage) {
            copy.forceAddItem(stack);
        }
        return copy;
    }

    public int getSlots() {
        return this.storage.size() + 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (slot >= 0 && slot < this.storage.size()) {
            return this.storage.get(slot);
        }
        return ItemStack.EMPTY;
    }

    @Nonnull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        int amountToAdd = Math.min(stack.getCount(), this.getFittableAmount(stack));
        if (amountToAdd <= 0) {
            return stack.copy();
        }
        ItemStack remainder = stack.copy();
        if (amountToAdd >= stack.getCount()) {
            remainder = ItemStack.EMPTY;
        } else {
            remainder.shrink(amountToAdd);
        }
        if (!simulate && amountToAdd > 0) {
            ItemStack addedStack = stack.copy();
            addedStack.setCount(amountToAdd);
            this.forceAddItem(addedStack);
        }
        return remainder;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stackInSlot = this.getStackInSlot(slot);
        int amountToRemove = Math.min(amount, stackInSlot.getCount());
        ItemStack removedStack = stackInSlot.copy();
        if (amountToRemove > 0) {
            removedStack.setCount(amountToRemove);
        } else {
            removedStack = ItemStack.EMPTY;
        }
        if (!simulate && amountToRemove > 0) {
            this.removeItem(removedStack);
        }
        return removedStack;
    }

    public int getSlotLimit(int slot) {
        return this.getMaxAmount();
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.allowItem(stack);
    }

    public static interface ITraderItemFilter {
        public boolean isItemRelevant(ItemStack var1);

        public int getStorageStackLimit();
    }

    public static class LockedTraderStorage
    extends TraderItemStorage {
        public LockedTraderStorage(ITraderItemFilter filter, List<ItemStack> startingInventory) {
            super(filter);
            for (ItemStack item : startingInventory) {
                this.forceAddItem(item);
            }
        }

        @Override
        public boolean allowItem(ItemStack item) {
            return false;
        }
    }
}

