/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral;

import dan200.computercraft.api.detail.VanillaDetailRegistries;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.util.ArgumentHelpers;
import dan200.computercraft.shared.peripheral.generic.GenericPeripheral;
import dan200.computercraft.shared.platform.ContainerTransfer;
import dan200.computercraft.shared.platform.ForgeContainerTransfer;
import dan200.computercraft.shared.util.CapabilityUtil;
import io.github.lightman314.lightmanscurrency.integration.computercraft.LCPeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.PeripheralMethod;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class InventoryPeripheral
extends LCPeripheral {
    private final Supplier<Boolean> hasAccess;
    private final Supplier<IItemHandler> handler;

    public InventoryPeripheral(Supplier<Boolean> hasAccess, IItemHandler handler) {
        this(hasAccess, () -> handler);
    }

    public InventoryPeripheral(Supplier<Boolean> hasAccess, Supplier<IItemHandler> handler) {
        this.hasAccess = hasAccess;
        this.handler = handler;
    }

    private boolean hasHandler() {
        return this.handler.get() != null;
    }

    private IItemHandler getHandler() {
        IItemHandler handler = this.handler.get();
        if (handler == null) {
            return new InvWrapper((Container)new SimpleContainer(0));
        }
        return handler;
    }

    public int size() {
        return this.getHandler().getSlots();
    }

    public Map<Integer, Map<String, ?>> list() {
        HashMap result = new HashMap();
        IItemHandler inventory = this.getHandler();
        int size = this.getHandler().getSlots();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            result.put(i + 1, VanillaDetailRegistries.ITEM_STACK.getBasicDetails((Object)stack));
        }
        return result;
    }

    @Nullable
    public Map<String, ?> getItemDetail(IArguments args) throws LuaException {
        IItemHandler inventory = this.getHandler();
        int slot = args.getInt(0);
        ArgumentHelpers.assertBetween((int)slot, (int)1, (int)inventory.getSlots(), (String)"Slot out of range (%s)");
        ItemStack stack = inventory.getStackInSlot(slot - 1);
        return stack.isEmpty() ? null : VanillaDetailRegistries.ITEM_STACK.getDetails((Object)stack);
    }

    public long getItemLimit(IArguments args) throws LuaException {
        IItemHandler inventory = this.getHandler();
        int slot = args.getInt(0);
        ArgumentHelpers.assertBetween((int)slot, (int)1, (int)inventory.getSlots(), (String)"Slot out of range (%s)");
        return inventory.getSlotLimit(slot - 1);
    }

    public int pushItems(IComputerAccess computer, IArguments args) throws LuaException {
        if (!this.hasAccess.get().booleanValue()) {
            return 0;
        }
        String toName = args.getString(0);
        int fromSlot = args.getInt(1);
        Optional limit = args.optInt(2);
        Optional toSlot = args.optInt(3);
        IItemHandler from = this.getHandler();
        IPeripheral location = computer.getAvailablePeripheral(toName);
        if (location == null) {
            throw new LuaException("Target '" + toName + "' does not exist");
        }
        IItemHandler to = InventoryPeripheral.extractHandler(location);
        if (to == null) {
            throw new LuaException("Source '" + toName + "' is not an inventory");
        }
        int actualLimit = limit.orElse(Integer.MAX_VALUE);
        ArgumentHelpers.assertBetween((int)fromSlot, (int)1, (int)from.getSlots(), (String)"From slot out of range (%s)");
        if (toSlot.isPresent()) {
            ArgumentHelpers.assertBetween((int)((Integer)toSlot.get()), (int)1, (int)to.getSlots(), (String)"To slot out of range (%s)");
        }
        return actualLimit <= 0 ? 0 : InventoryPeripheral.moveItem(from, fromSlot - 1, to, toSlot.orElse(0) - 1, actualLimit);
    }

    public int pullItems(IComputerAccess computer, IArguments args) throws LuaException {
        if (!this.hasAccess.get().booleanValue()) {
            return 0;
        }
        String fromName = args.getString(0);
        int fromSlot = args.getInt(1);
        Optional limit = args.optInt(2);
        Optional toSlot = args.optInt(3);
        IItemHandler to = this.getHandler();
        IPeripheral location = computer.getAvailablePeripheral(fromName);
        if (location == null) {
            throw new LuaException("Source '" + fromName + "' does not exist");
        }
        IItemHandler from = InventoryPeripheral.extractHandler(location);
        if (from == null) {
            throw new LuaException("Source '" + fromName + "' is not an inventory");
        }
        int actualLimit = limit.orElse(Integer.MAX_VALUE);
        ArgumentHelpers.assertBetween((int)fromSlot, (int)1, (int)from.getSlots(), (String)"From slot out of range (%s)");
        if (toSlot.isPresent()) {
            ArgumentHelpers.assertBetween((int)((Integer)toSlot.get()), (int)1, (int)to.getSlots(), (String)"To slot out of range (%s)");
        }
        return actualLimit <= 0 ? 0 : InventoryPeripheral.moveItem(from, fromSlot - 1, to, toSlot.orElse(0) - 1, actualLimit);
    }

    public String getType() {
        return "inventory";
    }

    public boolean equals(@Nullable IPeripheral peripheral) {
        if (peripheral instanceof InventoryPeripheral) {
            InventoryPeripheral other = (InventoryPeripheral)peripheral;
            return this.hasHandler() && other.hasHandler() && Objects.equals(this.getHandler(), other.getHandler());
        }
        return false;
    }

    @Nullable
    private static IItemHandler extractHandler(IPeripheral peripheral) {
        Direction var10000;
        Object object = peripheral.getTarget();
        if (peripheral instanceof GenericPeripheral) {
            GenericPeripheral sided = (GenericPeripheral)peripheral;
            var10000 = sided.side();
        } else {
            var10000 = null;
        }
        Direction direction = var10000;
        if (object instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)object;
            if (blockEntity.isRemoved()) {
                return null;
            }
            Level level = blockEntity.getLevel();
            if (!(level instanceof ServerLevel)) {
                return null;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            IItemHandler result = (IItemHandler)CapabilityUtil.getCapability((ServerLevel)serverLevel, (BlockCapability)Capabilities.ItemHandler.BLOCK, (BlockPos)blockEntity.getBlockPos(), (BlockState)blockEntity.getBlockState(), (BlockEntity)blockEntity, (Direction)direction);
            if (result != null) {
                return result;
            }
        }
        if (object instanceof IItemHandler) {
            IItemHandler handler = (IItemHandler)object;
            return handler;
        }
        if (object instanceof Container) {
            Container container = (Container)object;
            return new InvWrapper(container);
        }
        return null;
    }

    private static int moveItem(IItemHandler from, int fromSlot, IItemHandler to, int toSlot, int limit) {
        ForgeContainerTransfer fromWrapper = new ForgeContainerTransfer(from).singleSlot(fromSlot);
        ForgeContainerTransfer toWrapper = new ForgeContainerTransfer(to);
        if (toSlot >= 0) {
            toWrapper = toWrapper.singleSlot(toSlot);
        }
        return Math.max(0, fromWrapper.moveTo((ContainerTransfer)toWrapper, limit));
    }

    @Override
    protected void registerMethods(PeripheralMethod.Registration registration) {
        registration.register(PeripheralMethod.builder("size").simple(this::size).build());
        registration.register(PeripheralMethod.builder("list").simple(this::list).build());
        registration.register(PeripheralMethod.builder("getItemDetail").withArgs(this::getItemDetail).build());
        registration.register(PeripheralMethod.builder("getItemLimit").withArgs(this::getItemLimit).build());
        registration.register(PeripheralMethod.builder("pushItems").withContext(this::pushItems).withAccess(this.hasAccess).build());
        registration.register(PeripheralMethod.builder("pullItems").withContext(this::pullItems).withAccess(this.hasAccess).build());
    }
}

