/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.curios;

import io.github.lightman314.lightmanscurrency.common.items.PortableATMItem;
import io.github.lightman314.lightmanscurrency.common.items.PortableTerminalItem;
import io.github.lightman314.lightmanscurrency.integration.curios.LCCuriosInternal;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class LCCurios {
    public static final String WALLET_SLOT = "wallet";

    public static boolean isLoaded() {
        return ModList.get().isLoaded("curios");
    }

    public static boolean hasWalletSlot(LivingEntity entity) {
        return LCCurios.isLoaded() && LCCuriosInternal.hasWalletSlot(entity);
    }

    public static ItemStack getCuriosWalletItem(LivingEntity entity) {
        return LCCurios.isLoaded() ? LCCuriosInternal.getCuriosWalletItem(entity) : ItemStack.EMPTY;
    }

    public static ItemStack getVisibleCuriosWalletItem(LivingEntity entity) {
        return LCCurios.isLoaded() ? LCCuriosInternal.getVisibleCuriosWalletItem(entity) : ItemStack.EMPTY;
    }

    public static void setCuriosWalletItem(LivingEntity entity, ItemStack stack) {
        if (LCCurios.isLoaded()) {
            LCCuriosInternal.setCuriosWalletItem(entity, stack);
        }
    }

    public static boolean getCuriosWalletVisiblity(LivingEntity entity) {
        return LCCurios.isLoaded() && LCCuriosInternal.getCuriosWalletVisiblity(entity);
    }

    public static boolean hasItem(LivingEntity entity, Predicate<ItemStack> check) {
        return LCCurios.isLoaded() && LCCuriosInternal.hasItem(entity, check);
    }

    @Nullable
    public static Item lookupItem(LivingEntity entity, Predicate<ItemStack> check) {
        return !LCCurios.isLoaded() ? null : LCCuriosInternal.lookupItem(entity, check);
    }

    @Nullable
    public static Item lookupPortableTerminal(LivingEntity entity) {
        return LCCurios.lookupItem(entity, stack -> stack.getItem() instanceof PortableTerminalItem);
    }

    @Nullable
    public static Item lookupPortableATM(LivingEntity entity) {
        return LCCurios.lookupItem(entity, stack -> stack.getItem() instanceof PortableATMItem);
    }

    @Nullable
    public static ItemStack getRandomItem(LivingEntity entity, Predicate<ItemStack> check) {
        return LCCurios.isLoaded() ? LCCuriosInternal.getRandomItem(entity, check) : null;
    }

    public static void setup(IEventBus modBus) {
        if (LCCurios.isLoaded()) {
            LCCuriosInternal.setup(modBus);
        }
    }
}

