/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.mixin.compat.create;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.stockTicker.StockTickerInteractionHandler;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.ChainData;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyStorage;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.api.money.value.builtin.CoinValue;
import io.github.lightman314.lightmanscurrency.common.attachments.WalletHandler;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import io.github.lightman314.lightmanscurrency.mixinsupport.create.WalletInventoryWrapper;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.HashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={StockTickerInteractionHandler.class})
public class StockTickerInteractionHandlerMixin {
    @Unique
    private static WalletInventoryWrapper lightmanscurrency$wrapper;

    @Inject(at={@At(value="FIELD", target="net/createmod/catnip/data/Iterate.trueAndFalse:[Z")}, method={"interactWithShop"}, cancellable=true)
    private static void interactWithShop(Player player, Level level, BlockPos targetPos, ItemStack mainHandItem, CallbackInfo ci, @Local(name={"paymentEntries"}) InventorySummary paymentEntries) {
        ItemStack wallet;
        StockTickerInteractionHandlerMixin.lightmanscurrency$clearWrapper(true);
        WalletHandler walletHandler = WalletHandler.get((LivingEntity)player);
        ItemStack itemStack = wallet = walletHandler == null ? ItemStack.EMPTY : walletHandler.getWallet();
        if (!WalletItem.isWallet(wallet)) {
            return;
        }
        HashMap<Item, Integer> map = new HashMap<Item, Integer>();
        for (BigItemStack stack : paymentEntries.getStacks()) {
            if (CoinAPI.getApi().IsCoin(stack.stack, false)) {
                map.put(stack.stack.getItem(), stack.count);
                continue;
            }
            return;
        }
        Inventory inventory = player.getInventory();
        for (int i = 0; i < inventory.items.size(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (!map.containsKey(item.getItem())) continue;
            map.put(item.getItem(), (Integer)map.get(item.getItem()) - item.getCount());
        }
        MoneyStorage cost = new MoneyStorage(() -> {});
        for (Item coin : map.keySet()) {
            ChainData chain = CoinAPI.getApi().ChainDataOfCoin(coin);
            int count = (Integer)map.get(coin);
            if (count <= 0) continue;
            cost.addValue(CoinValue.fromNumber(chain, (long)count));
        }
        if (!cost.isEmpty()) {
            MoneyView available = MoneyAPI.getApi().GetContainersMoneyHandler(WalletItem.getDataWrapper(wallet).getContents(), s -> {}, IClientTracker.forServer()).getStoredMoney();
            for (MoneyValue c : cost.allValues()) {
                if (available.containsValue(c)) continue;
                player.playNotifySound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(VersionUtil.modResource("create", "deny")), SoundSource.PLAYERS, 1.0f, 0.5f);
                player.displayClientMessage((Component)EasyText.translatable("create.stock_keeper.too_broke", new Object[0]).withStyle(ChatFormatting.RED), true);
                ci.cancel();
                return;
            }
        }
    }

    @WrapOperation(at={@At(value="INVOKE", target="net/minecraft/world/entity/player/Player.getInventory()Lnet/minecraft/world/entity/player/Inventory;")}, method={"interactWithShop"})
    private static Inventory wrapInventory(Player player, Operation<Inventory> next, @Local(name={"paymentEntries"}) InventorySummary paymentEntries) {
        ItemStack wallet;
        if (player.level().isClientSide) {
            return (Inventory)next.call(new Object[]{player});
        }
        StockTickerInteractionHandlerMixin.lightmanscurrency$clearWrapper(false);
        WalletHandler walletHandler = WalletHandler.get((LivingEntity)player);
        ItemStack itemStack = wallet = walletHandler == null ? ItemStack.EMPTY : walletHandler.getWallet();
        if (!WalletItem.isWallet(wallet)) {
            return (Inventory)next.call(new Object[]{player});
        }
        for (BigItemStack stack : paymentEntries.getStacks()) {
            if (!CoinAPI.getApi().IsCoin(stack.stack, false)) continue;
            lightmanscurrency$wrapper = new WalletInventoryWrapper((Inventory)next.call(new Object[]{player}), walletHandler, paymentEntries.copy());
            return lightmanscurrency$wrapper;
        }
        return (Inventory)next.call(new Object[]{player});
    }

    @Inject(at={@At(value="RETURN")}, method={"interactWithShop"})
    private static void interactWithShop(Player player, Level level, BlockPos targetPos, ItemStack mainHandItem, CallbackInfo ci) {
        StockTickerInteractionHandlerMixin.lightmanscurrency$clearWrapper(true);
    }

    @Unique
    private static void lightmanscurrency$clearWrapper(boolean finished) {
        if (lightmanscurrency$wrapper != null) {
            lightmanscurrency$wrapper.clearContents(finished);
            lightmanscurrency$wrapper = null;
        }
    }
}

