/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.bank;

import io.github.lightman314.lightmanscurrency.api.money.bank.BankAPI;
import io.github.lightman314.lightmanscurrency.api.money.bank.menu.IBankAccountAdvancedMenu;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.network.message.bank.SPacketBankTransferResponse;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class CPacketBankTransferAccount
extends ClientToServerPacket {
    private static final CustomPacketPayload.Type<CPacketBankTransferAccount> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("c_bank_transfer_team"));
    public static final CustomPacket.Handler<CPacketBankTransferAccount> HANDLER = new H();
    BankReference target;
    MoneyValue amount;

    public CPacketBankTransferAccount(BankReference target, MoneyValue amount) {
        super(TYPE);
        this.target = target;
        this.amount = amount;
    }

    private static void encode(@Nonnull FriendlyByteBuf buffer, @Nonnull CPacketBankTransferAccount message) {
        message.target.encode(buffer);
        message.amount.encode(buffer);
    }

    private static CPacketBankTransferAccount decode(@Nonnull FriendlyByteBuf buffer) {
        return new CPacketBankTransferAccount(BankReference.decode(buffer), MoneyValue.decode(buffer));
    }

    private static class H
    extends CustomPacket.Handler<CPacketBankTransferAccount> {
        protected H() {
            super(TYPE, CustomPacket.easyCodec(CPacketBankTransferAccount::encode, CPacketBankTransferAccount::decode));
        }

        @Override
        protected void handle(@Nonnull CPacketBankTransferAccount message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof IBankAccountAdvancedMenu) {
                IBankAccountAdvancedMenu menu = (IBankAccountAdvancedMenu)abstractContainerMenu;
                MutableComponent response = BankAPI.getApi().BankTransfer(menu, message.amount, message.target.get());
                if (response != null) {
                    context.reply((CustomPacketPayload)new SPacketBankTransferResponse((Component)response));
                }
            }
        }
    }
}

