/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.wallet;

import io.github.lightman314.lightmanscurrency.common.menus.wallet.WalletMenuBase;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class CPacketOpenWalletBank
extends ClientToServerPacket {
    private static final CustomPacketPayload.Type<CPacketOpenWalletBank> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("c_wallet_open_bank"));
    public static final CustomPacket.Handler<CPacketOpenWalletBank> HANDLER = new H();
    private final int walletStackIndex;

    public CPacketOpenWalletBank(int walletStackIndex) {
        super(TYPE);
        this.walletStackIndex = walletStackIndex;
    }

    private static void encode(@Nonnull FriendlyByteBuf buffer, @Nonnull CPacketOpenWalletBank message) {
        buffer.writeInt(message.walletStackIndex);
    }

    private static CPacketOpenWalletBank decode(@Nonnull FriendlyByteBuf buffer) {
        return new CPacketOpenWalletBank(buffer.readInt());
    }

    private static class H
    extends CustomPacket.Handler<CPacketOpenWalletBank> {
        protected H() {
            super(TYPE, CustomPacket.easyCodec(CPacketOpenWalletBank::encode, CPacketOpenWalletBank::decode));
        }

        @Override
        protected void handle(@Nonnull CPacketOpenWalletBank message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                WalletMenuBase.SafeOpenWalletBankMenu((Player)sp, message.walletStackIndex);
            }
        }
    }
}

