/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyScreen;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class ConfigScreen
extends EasyScreen {
    private final Screen parentScreen;
    public static final int BOTTOM_BUTTON_OFFSET = 25;
    private static final ResourceLocation MENU_LIST_BACKGROUND = ResourceLocation.withDefaultNamespace((String)"textures/gui/menu_list_background.png");
    private static final ResourceLocation INWORLD_MENU_LIST_BACKGROUND = ResourceLocation.withDefaultNamespace((String)"textures/gui/inworld_menu_list_background.png");

    public ConfigScreen(Screen parentScreen) {
        super((Component)EasyText.empty());
        this.parentScreen = parentScreen;
    }

    @Override
    protected void preInit() {
        this.resize(this.width, this.height);
    }

    public final void onClose() {
        this.minecraft.setScreen(this.parentScreen);
        this.afterClose();
    }

    protected void afterClose() {
    }

    protected int headerSize() {
        return 33;
    }

    protected int footerSize() {
        return 33;
    }

    @Override
    protected final void renderBG(EasyGuiGraphics gui) {
        ScreenArea area = this.getArea();
        ResourceLocation header = this.minecraft.level != null ? Screen.INWORLD_HEADER_SEPARATOR : Screen.HEADER_SEPARATOR;
        gui.blit(header, 0, this.headerSize() - 2, 0, 0, area.width, 2, 32, 2);
        RenderSystem.enableBlend();
        ResourceLocation background = this.minecraft.level != null ? INWORLD_MENU_LIST_BACKGROUND : MENU_LIST_BACKGROUND;
        gui.blit(background, 0, this.headerSize(), 0, 0, area.width, area.height - this.headerSize() - this.footerSize(), 32, 32);
        RenderSystem.disableBlend();
        ResourceLocation footer = this.minecraft.level != null ? Screen.INWORLD_FOOTER_SEPARATOR : Screen.FOOTER_SEPARATOR;
        gui.blit(footer, 0, area.height - this.footerSize(), 0, 0, area.width, 2, 32, 2);
        TextRenderUtil.drawCenteredText(gui, this.getTitle(), this.getArea().centerX(), 10, 0xFFFFFF, true);
        this.renderAdditionalBG(gui);
    }

    public Component getTitle() {
        MutableComponent partialTitle = EasyText.empty();
        List<Component> titleSections = this.getTitleSections();
        if (titleSections.isEmpty()) {
            return partialTitle;
        }
        if (titleSections.size() == 1) {
            return titleSections.getFirst();
        }
        for (int i = 0; i < titleSections.size(); ++i) {
            if (i > 0) {
                partialTitle.append((Component)LCText.CONFIG_TITLE_SEPERATOR.get(new Object[0]));
            }
            partialTitle.append(titleSections.get(i));
        }
        return partialTitle;
    }

    protected abstract List<Component> getTitleSections();

    @Override
    public boolean blockInventoryClosing() {
        return true;
    }

    protected void renderAdditionalBG(EasyGuiGraphics gui) {
    }

    @Override
    public boolean isPauseScreen() {
        return true;
    }
}

