/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.client.screen.builtin.subscreens.trade_mod;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.builtin.subscreens.trade_mod.ConfiguredTradeModConfigScreen;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.options.ConfigFileOption;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.widget.dropdown.DropdownWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.config.VillagerTradeModsOption;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.listings.mods.ConfiguredTradeMod;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.listings.mods.VillagerTradeMods;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class VillagerTradeModConfigScreen
extends ConfiguredTradeModConfigScreen {
    private static VillagerTradeModConfigScreen activeScreen;
    private final VillagerTradeModsOption option;
    private final Consumer<Object> changeHandler;
    private List<VillagerProfession> professions = null;
    private VillagerProfession selectedProfession = null;
    private DropdownWidget professionSelection;

    private String getSelectedProfessionKey() {
        if (this.selectedProfession == null) {
            this.collectVillagerTypes();
        }
        return BuiltInRegistries.VILLAGER_PROFESSION.getKey((Object)this.selectedProfession).toString();
    }

    public VillagerTradeModConfigScreen(Screen parentScreen, ConfigFileOption file, VillagerTradeModsOption option, Consumer<Object> changeHandler) {
        super(parentScreen, file, option, VillagerTradeModConfigScreen::getSelectedMod, VillagerTradeModConfigScreen::handleModChange, false);
        this.option = option;
        this.changeHandler = changeHandler;
    }

    @Override
    protected void initialize(ScreenArea screenArea) {
        activeScreen = this;
        this.collectVillagerTypes();
        this.professionSelection = this.addChild(((DropdownWidget.Builder)DropdownWidget.builder().position(screenArea.centerX() - 75, screenArea.centerY() - 110)).width(150).options(this.professions.stream().map(VillagerTradeModConfigScreen::getProfessionName).toList()).selected(this.professions.indexOf(this.selectedProfession)).selectAction(this::changeProfession).build());
        super.initialize(screenArea);
    }

    @Override
    protected void renderAdditionalBG(EasyGuiGraphics gui) {
        super.renderAdditionalBG(gui);
        if (this.professionSelection != null) {
            TextRenderUtil.drawCenteredText(gui, (Component)LCText.CONFIG_TRADE_MOD_PROFESSION.get(new Object[0]), this.professionSelection.getArea().centerX(), this.professionSelection.getY() - 10, 0xFFFFFF, true);
        }
    }

    private static Component getProfessionName(VillagerProfession profession) {
        ResourceLocation profID = BuiltInRegistries.VILLAGER_PROFESSION.getKey((Object)profession);
        return EasyText.translatable(EntityType.VILLAGER.getDescriptionId() + "." + (String)(!"minecraft".equals(profID.getNamespace()) ? profID.getNamespace() + "." : "") + profID.getPath(), new Object[0]);
    }

    private void collectVillagerTypes() {
        if (this.professions == null) {
            this.professions = BuiltInRegistries.VILLAGER_PROFESSION.stream().filter(VillagerTradeModConfigScreen::allowProfessionSelection).toList();
            this.selectedProfession = this.professions.getFirst();
        }
    }

    private static boolean allowProfessionSelection(VillagerProfession profession) {
        return profession != VillagerProfession.NITWIT && profession != VillagerProfession.NONE;
    }

    private void changeProfession(int newIndex) {
        VillagerProfession profession = this.professions.get(newIndex);
        if (profession != this.selectedProfession) {
            this.selectedProfession = profession;
            this.onDataChanged(this.option);
        }
    }

    private static ConfiguredTradeMod getEmptyMod() {
        return new ConfiguredTradeMod((Pair<Item, Item>)Pair.of(null, null), (Map<String, Pair<Item, Item>>)ImmutableMap.of());
    }

    private static ConfiguredTradeMod getSelectedMod() {
        if (activeScreen == null) {
            return VillagerTradeModConfigScreen.getEmptyMod();
        }
        VillagerTradeMods mods = (VillagerTradeMods)VillagerTradeModConfigScreen.activeScreen.option.get();
        return mods.getModMap().getOrDefault(activeScreen.getSelectedProfessionKey(), VillagerTradeModConfigScreen.getEmptyMod());
    }

    private static void handleModChange(Object newMod) {
        if (activeScreen != null && newMod instanceof ConfiguredTradeMod) {
            ConfiguredTradeMod mod = (ConfiguredTradeMod)newMod;
            VillagerTradeMods mods = (VillagerTradeMods)VillagerTradeModConfigScreen.activeScreen.option.get();
            String professionKey = activeScreen.getSelectedProfessionKey();
            HashMap<String, ConfiguredTradeMod> data = new HashMap<String, ConfiguredTradeMod>(mods.getModMap());
            if (mod.isEmpty() && data.containsKey(professionKey)) {
                data.remove(professionKey);
                VillagerTradeModConfigScreen.activeScreen.changeHandler.accept(new VillagerTradeMods(data));
            } else {
                data.put(professionKey, mod);
                VillagerTradeModConfigScreen.activeScreen.changeHandler.accept(new VillagerTradeMods(data));
            }
        }
    }

    @Override
    protected void afterClose() {
        super.afterClose();
        activeScreen = null;
    }
}

