/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.blocks;

import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.IBlockCapabilityProvider;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.joml.Vector3f;

public interface IRotatableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public static BlockPos getRightPos(BlockPos pos, Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> new BlockPos(pos.getX() + 1, pos.getY(), pos.getZ());
            case Direction.SOUTH -> new BlockPos(pos.getX() - 1, pos.getY(), pos.getZ());
            case Direction.EAST -> new BlockPos(pos.getX(), pos.getY(), pos.getZ() + 1);
            case Direction.WEST -> new BlockPos(pos.getX(), pos.getY(), pos.getZ() - 1);
            default -> pos;
        };
    }

    public static BlockPos getLeftPos(BlockPos pos, Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> new BlockPos(pos.getX() - 1, pos.getY(), pos.getZ());
            case Direction.SOUTH -> new BlockPos(pos.getX() + 1, pos.getY(), pos.getZ());
            case Direction.EAST -> new BlockPos(pos.getX(), pos.getY(), pos.getZ() - 1);
            case Direction.WEST -> new BlockPos(pos.getX(), pos.getY(), pos.getZ() + 1);
            default -> pos;
        };
    }

    public static BlockPos getForwardPos(BlockPos pos, Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> new BlockPos(pos.getX(), pos.getY(), pos.getZ() - 1);
            case Direction.SOUTH -> new BlockPos(pos.getX(), pos.getY(), pos.getZ() + 1);
            case Direction.EAST -> new BlockPos(pos.getX() + 1, pos.getY(), pos.getZ());
            case Direction.WEST -> new BlockPos(pos.getX() - 1, pos.getY(), pos.getZ());
            default -> pos;
        };
    }

    public static BlockPos getBackwardPos(BlockPos pos, Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> new BlockPos(pos.getX(), pos.getY(), pos.getZ() + 1);
            case Direction.SOUTH -> new BlockPos(pos.getX(), pos.getY(), pos.getZ() - 1);
            case Direction.EAST -> new BlockPos(pos.getX() - 1, pos.getY(), pos.getZ());
            case Direction.WEST -> new BlockPos(pos.getX() + 1, pos.getY(), pos.getZ());
            default -> pos;
        };
    }

    public static Vector3f getRightVect(Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> new Vector3f(1.0f, 0.0f, 0.0f);
            case Direction.SOUTH -> new Vector3f(-1.0f, 0.0f, 0.0f);
            case Direction.EAST -> new Vector3f(0.0f, 0.0f, 1.0f);
            case Direction.WEST -> new Vector3f(0.0f, 0.0f, -1.0f);
            default -> new Vector3f(0.0f, 0.0f, 0.0f);
        };
    }

    public static Vector3f getLeftVect(Direction facing) {
        return MathUtil.VectorMult(IRotatableBlock.getRightVect(facing), -1.0f);
    }

    public static Vector3f getForwardVect(Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> new Vector3f(0.0f, 0.0f, -1.0f);
            case Direction.SOUTH -> new Vector3f(0.0f, 0.0f, 1.0f);
            case Direction.EAST -> new Vector3f(1.0f, 0.0f, 0.0f);
            case Direction.WEST -> new Vector3f(-1.0f, 0.0f, 0.0f);
            default -> new Vector3f(0.0f, 0.0f, 0.0f);
        };
    }

    public static Vector3f getBackwardVect(Direction facing) {
        return MathUtil.VectorMult(IRotatableBlock.getForwardVect(facing), -1.0f);
    }

    public static Vector3f getOffsetVect(Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> new Vector3f(0.0f, 0.0f, 1.0f);
            case Direction.SOUTH -> new Vector3f(1.0f, 0.0f, 0.0f);
            case Direction.WEST -> new Vector3f(1.0f, 0.0f, 1.0f);
            default -> new Vector3f(0.0f, 0.0f, 0.0f);
        };
    }

    default public Direction getFacing(BlockState state) {
        return (Direction)state.getValue((Property)FACING);
    }

    public static Direction getRelativeSide(Direction facing, Direction side) {
        if (side == null) {
            return null;
        }
        if (side.getAxis() == Direction.Axis.Y) {
            return side;
        }
        if (facing.getAxis() == Direction.Axis.Z) {
            facing = facing.getOpposite();
        }
        return Direction.from2DDataValue((int)(facing.get2DDataValue() + side.get2DDataValue()));
    }

    public static Direction getActualSide(Direction facing, Direction relativeSide) {
        Direction result;
        if (relativeSide == null) {
            return null;
        }
        if (relativeSide.getAxis() == Direction.Axis.Y) {
            return relativeSide;
        }
        if (facing.getAxis() == Direction.Axis.Z) {
            facing = facing.getOpposite();
        }
        return (result = Direction.from2DDataValue((int)(facing.get2DDataValue() - relativeSide.get2DDataValue() + 4))).getAxis() == Direction.Axis.X ? result.getOpposite() : result;
    }

    default public int getRotationY(BlockState state) {
        return this.getRotationY(this.getFacing(state));
    }

    default public int getRotationY(Direction facing) {
        return switch (facing) {
            case Direction.EAST -> 90;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 270;
            default -> 0;
        };
    }

    default public int getRotationYInv(Direction facing) {
        return switch (facing) {
            case Direction.WEST -> 90;
            case Direction.NORTH -> 180;
            case Direction.EAST -> 270;
            default -> 0;
        };
    }

    public static <T, BE extends BlockEntity> void registerRotatableCapability(@Nonnull RegisterCapabilitiesEvent event, @Nonnull BlockCapability<T, Direction> capability, @Nonnull BlockEntityType<BE> type, @Nonnull BiFunction<BE, Direction, T> getter) {
        event.registerBlockEntity(capability, type, (be, side) -> {
            Block patt0$temp = be.getBlockState().getBlock();
            if (patt0$temp instanceof IRotatableBlock) {
                IRotatableBlock rb = (IRotatableBlock)patt0$temp;
                side = IRotatableBlock.getRelativeSide(rb.getFacing(be.getBlockState()), side);
            }
            return getter.apply((Object)be, (Direction)side);
        });
    }

    public static <T, BE extends BlockEntity> void registerRotatableCapability(@Nonnull RegisterCapabilitiesEvent event, @Nonnull BlockCapability<T, Direction> capability, @Nonnull IBlockCapabilityProvider<T, Direction> getter, Block ... blocks) {
        event.registerBlock(capability, (level, pos, state, be, side) -> {
            Block patt0$temp = be.getBlockState().getBlock();
            if (patt0$temp instanceof IRotatableBlock) {
                IRotatableBlock rb = (IRotatableBlock)patt0$temp;
                side = IRotatableBlock.getRelativeSide(rb.getFacing(be.getBlockState()), side);
            }
            return getter.getCapability(level, pos, state, be, side);
        }, new Block[0]);
    }
}

