/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.blocks;

import io.github.lightman314.lightmanscurrency.api.misc.blocks.ITallBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.LazyShapes;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.RotatableBlock;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TallRotatableBlock
extends RotatableBlock
implements ITallBlock {
    private final BiFunction<Direction, Boolean, VoxelShape> shape;

    protected TallRotatableBlock(BlockBehaviour.Properties properties) {
        this(properties, LazyShapes.TALL_BOX_SHAPE);
    }

    protected TallRotatableBlock(BlockBehaviour.Properties properties, VoxelShape shape) {
        this(properties, LazyShapes.lazyTallSingleShape(shape));
    }

    protected TallRotatableBlock(BlockBehaviour.Properties properties, BiFunction<Direction, Boolean, VoxelShape> shape) {
        super(properties.pushReaction(PushReaction.BLOCK));
        this.shape = shape;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)ISBOTTOM, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return this.shape.apply(this.getFacing(state), this.getIsBottom(state));
    }

    @Override
    protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ISBOTTOM});
    }

    @Override
    public BlockState getStateForPlacement(@Nonnull BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)ISBOTTOM, (Comparable)Boolean.valueOf(true));
    }

    @Override
    public void setPlacedBy(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, LivingEntity player, @Nonnull ItemStack stack) {
        if (this.isReplaceable(level, pos.above())) {
            level.setBlockAndUpdate(pos.above(), (BlockState)((BlockState)this.defaultBlockState().setValue((Property)ISBOTTOM, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))));
        } else {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 35);
            if (player instanceof Player) {
                ItemStack giveStack = stack.copy();
                giveStack.setCount(1);
                ((Player)player).getInventory().add(giveStack);
            }
        }
        this.tryCopyVariant(level, pos, stack);
    }

    @Nonnull
    public BlockState updateShape(@Nonnull BlockState stateIn, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor worldIn, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (facing == Direction.UP && ((Boolean)stateIn.getValue((Property)ISBOTTOM)).booleanValue() || facing == Direction.DOWN && !((Boolean)stateIn.getValue((Property)ISBOTTOM)).booleanValue()) {
            if (facingState.is((Block)this)) {
                return stateIn;
            }
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }
}

