/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.coins;

import io.github.lightman314.lightmanscurrency.api.money.coins.data.ChainData;
import io.github.lightman314.lightmanscurrency.common.impl.CoinAPIImpl;
import io.github.lightman314.lightmanscurrency.network.message.data.SPacketSyncCoinData;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class CoinAPI {
    private static CoinAPI instance;
    public static final Comparator<ItemStack> COIN_SORTER;
    public static final String MONEY_FILE_LOCATION = "config/lightmanscurrency/MasterCoinList.json";
    public static final String MAIN_CHAIN = "main";

    public static CoinAPI getApi() {
        if (instance == null) {
            instance = new CoinAPIImpl();
        }
        return instance;
    }

    protected CoinAPI() {
        if (instance != null) {
            throw new IllegalCallerException("Cannot create a new CoinAPI instance as one is already present!");
        }
    }

    public abstract boolean NoDataAvailable();

    public abstract void Setup();

    public abstract void ReloadCoinDataFromFile();

    public abstract ItemStack getEquippedWallet(Player var1);

    @Nullable
    public abstract ChainData ChainData(String var1);

    public abstract List<ChainData> AllChainData();

    @Nullable
    public abstract ChainData ChainDataOfCoin(ItemStack var1);

    @Nullable
    public abstract ChainData ChainDataOfCoin(Item var1);

    public abstract boolean IsCoin(ItemStack var1, boolean var2);

    public abstract boolean IsCoin(Item var1, boolean var2);

    public abstract void RegisterCoinContainerFilter(BiPredicate<ItemStack, Boolean> var1);

    public abstract boolean IsAllowedInCoinContainer(ItemStack var1, boolean var2);

    public abstract boolean IsAllowedInCoinContainer(Item var1, boolean var2);

    public abstract void CoinExchangeAllUp(Container var1);

    public abstract void CoinExchangeUp(Container var1, Item var2);

    public abstract void CoinExchangeAllDown(Container var1);

    public abstract void CoinExchangeDown(Container var1, Item var2);

    public abstract void SortCoinsByValue(Container var1);

    public abstract SPacketSyncCoinData getSyncPacket();

    public abstract void SyncCoinDataWith(@Nullable Player var1);

    public abstract void HandleSyncPacket(SPacketSyncCoinData var1);

    public abstract void RegisterCustomSorter(Comparator<ItemStack> var1);

    static {
        COIN_SORTER = new CoinAPIImpl.CoinSorter();
    }
}

