/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.coins.display.builtin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.ChainData;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.coin.CoinEntry;
import io.github.lightman314.lightmanscurrency.api.money.coins.display.ValueDisplayData;
import io.github.lightman314.lightmanscurrency.api.money.coins.display.ValueDisplaySerializer;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.builtin.CoinValue;
import io.github.lightman314.lightmanscurrency.common.text.TextEntry;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.text.DecimalFormat;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class NumberDisplay
extends ValueDisplayData {
    public static final ResourceLocation TYPE = VersionUtil.lcResource("number");
    public static final ValueDisplaySerializer SERIALIZER = new Serializer();
    private final Pair<String, Boolean> format;
    private final Pair<String, Boolean> wordyFormat;
    private final Item baseItem;
    private CoinEntry baseEntry = null;

    private Pair<String, Boolean> getWordyFormat() {
        return this.wordyFormat != null ? this.wordyFormat : this.format;
    }

    @Nullable
    private CoinEntry getBaseEntry() {
        ChainData parent;
        if (this.baseEntry == null && (parent = this.getParent()) != null) {
            this.baseEntry = parent.findEntry(this.baseItem);
        }
        return this.baseEntry;
    }

    public NumberDisplay(@Nonnull TextEntry format, @Nonnull Item baseItem) {
        this((Pair<String, Boolean>)Pair.of((Object)format.getKey(), (Object)true), baseItem);
    }

    public NumberDisplay(@Nonnull String literalFormat, @Nonnull Item baseItem) {
        this((Pair<String, Boolean>)Pair.of((Object)literalFormat, (Object)false), baseItem);
    }

    public NumberDisplay(@Nonnull Pair<String, Boolean> format, @Nonnull Item baseItem) {
        this.format = format;
        this.wordyFormat = format;
        this.baseItem = baseItem;
    }

    public NumberDisplay(@Nonnull TextEntry format, @Nullable TextEntry wordyFormat, @Nonnull Item baseItem) {
        this((Pair<String, Boolean>)Pair.of((Object)format.getKey(), (Object)true), (Pair<String, Boolean>)Pair.of((Object)wordyFormat.getKey(), (Object)true), baseItem);
    }

    public NumberDisplay(@Nonnull String literalFormat, @Nullable String literalWordyFormat, @Nonnull Item baseItem) {
        this((Pair<String, Boolean>)Pair.of((Object)literalFormat, (Object)false), literalWordyFormat == null ? null : Pair.of((Object)literalWordyFormat, (Object)false), baseItem);
    }

    public NumberDisplay(@Nonnull Pair<String, Boolean> format, @Nullable Pair<String, Boolean> wordyFormat, @Nonnull Item baseItem) {
        this.format = format;
        this.wordyFormat = wordyFormat;
        this.baseItem = baseItem;
    }

    @Override
    @Nonnull
    public ValueDisplaySerializer getSerializer() {
        return SERIALIZER;
    }

    public double getDisplayValue(long coreValue) {
        CoinEntry baseUnit = this.getBaseEntry();
        if (baseUnit == null || baseUnit.getCoreValue() <= 0L) {
            return 0.0;
        }
        return (double)coreValue / (double)baseUnit.getCoreValue();
    }

    private double getDisplayValue(@Nonnull Item item) {
        ChainData parent = this.getParent();
        if (parent == null) {
            return 0.0;
        }
        return this.getDisplayValue(parent.getCoreValue(item));
    }

    private MutableComponent formatDisplay(double value) {
        return this.format(this.format, LCText.TOOLTIP_COIN_DISPLAY_NUMBER, this.formatDisplayNumber(value));
    }

    private MutableComponent formatWordyDisplay(double value) {
        TextEntry format = LCText.TOOLTIP_COIN_DISPLAY_NUMBER;
        if (this.wordyFormat != null) {
            format = LCText.TOOLTIP_COIN_DISPLAY_NUMBER_WORDY;
        }
        return this.format(this.getWordyFormat(), format, this.formatDisplayNumber(value));
    }

    protected Component getIcon() {
        return NumberDisplay.getIcon(this.getChain());
    }

    private MutableComponent format(@Nonnull Pair<String, Boolean> format, @Nonnull TextEntry iconFormat, @Nonnull String value) {
        if (((Boolean)format.getSecond()).booleanValue()) {
            return EasyText.translatable((String)format.getFirst(), iconFormat.get(value, this.getIcon()));
        }
        return EasyText.literal(String.format(((String)format.getFirst()).replace("{value}", value), new Object[0]));
    }

    @Nonnull
    private String formatDisplayNumber(double value) {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(this.getMaxDecimal());
        return df.format(value);
    }

    public int getMaxDecimal() {
        double minFraction = this.getDisplayValue(1L) % 1.0;
        if (minFraction > 0.0) {
            return Double.toString(minFraction).length() - 2;
        }
        return 0;
    }

    @Override
    @Nonnull
    public MutableComponent formatValue(@Nonnull CoinValue value, @Nonnull MutableComponent emptyText) {
        return this.formatDisplay(this.getDisplayValue(value.getCoreValue()));
    }

    @Override
    public void formatCoinTooltip(@Nonnull ItemStack stack, @Nonnull List<Component> tooltip) {
        double value = this.getDisplayValue(stack.getItem());
        tooltip.add((Component)LCText.TOOLTIP_COIN_WORTH_VALUE.get(this.formatWordyDisplay(value)).withStyle(ChatFormatting.YELLOW));
        if (stack.getCount() > 1) {
            tooltip.add((Component)LCText.TOOLTIP_COIN_WORTH_VALUE_STACK.get(this.formatWordyDisplay(value * (double)stack.getCount())).withStyle(ChatFormatting.YELLOW));
        }
    }

    @Override
    @Nonnull
    public MoneyValue parseDisplayInput(double displayInput) {
        CoinEntry baseUnit = this.getBaseEntry();
        if (baseUnit == null) {
            return MoneyValue.empty();
        }
        long baseCoinValue = baseUnit.getCoreValue();
        double totalValue = displayInput * (double)baseCoinValue;
        long value = (long)totalValue;
        if (totalValue % 1.0 >= 0.5) {
            ++value;
        }
        return CoinValue.fromNumber(this.getChain(), value);
    }

    @Nonnull
    public Pair<String, String> getSplitFormat() {
        return this.splitFormat(this.format, LCText.TOOLTIP_COIN_DISPLAY_NUMBER);
    }

    @Nonnull
    public Pair<String, String> getSplitWordyFormat() {
        TextEntry format = LCText.TOOLTIP_COIN_DISPLAY_NUMBER;
        if (this.wordyFormat != null) {
            format = LCText.TOOLTIP_COIN_DISPLAY_NUMBER_WORDY;
        }
        return this.splitFormat(this.getWordyFormat(), format);
    }

    @Nonnull
    private Pair<String, String> splitFormat(@Nonnull Pair<String, Boolean> format, @Nonnull TextEntry iconFormat) {
        String formatString = this.format(format, iconFormat, "`").getString();
        String[] splitFormat = formatString.split("`", 2);
        if (splitFormat.length < 2) {
            if (formatString.startsWith("`")) {
                return Pair.of((Object)"", (Object)splitFormat[0]);
            }
            return Pair.of((Object)splitFormat[0], (Object)"");
        }
        return Pair.of((Object)splitFormat[0], (Object)splitFormat[1]);
    }

    protected static class Serializer
    extends ValueDisplaySerializer {
        private Pair<String, Boolean> format = null;
        private Pair<String, Boolean> wordyFormat = null;
        private Item baseUnit = null;
        private Item firstCoin = null;

        protected Serializer() {
        }

        @Override
        @Nonnull
        public ResourceLocation getType() {
            return TYPE;
        }

        @Override
        public void resetBuilder() {
            this.wordyFormat = null;
            this.format = null;
            this.firstCoin = null;
            this.baseUnit = null;
        }

        @Override
        public void parseAdditional(@Nonnull JsonObject chainJson) throws JsonSyntaxException, ResourceLocationException {
            this.format = Serializer.parseFormat(chainJson, "displayFormat");
            if (chainJson.has("displayFormatWordy")) {
                this.wordyFormat = Serializer.parseFormat(chainJson, "displayFormatWordy");
            }
        }

        @Override
        public void parseAdditionalFromCoin(@Nonnull CoinEntry coin, @Nonnull JsonObject coinEntry) throws JsonSyntaxException, ResourceLocationException {
            if (GsonHelper.getAsBoolean((JsonObject)coinEntry, (String)"baseUnit", (boolean)false)) {
                if (this.baseUnit != null) {
                    LightmansCurrency.LogWarning("Multiple coins in this chain have a 'baseUnit' flag! Ignoring duplicate entries.");
                }
                this.baseUnit = coin.getCoin();
            } else if (this.firstCoin == null) {
                this.firstCoin = coin.getCoin();
            }
        }

        @Override
        public void writeAdditional(@Nonnull ValueDisplayData data, @Nonnull JsonObject chainJson) {
            if (data instanceof NumberDisplay) {
                NumberDisplay display = (NumberDisplay)data;
                Serializer.saveFormat(chainJson, "displayFormat", display.format);
                if (display.wordyFormat != null) {
                    Serializer.saveFormat(chainJson, "displayFormatWordy", display.wordyFormat);
                }
            }
        }

        @Override
        public void writeAdditionalToCoin(@Nonnull ValueDisplayData data, @Nonnull CoinEntry coin, @Nonnull JsonObject coinEntry) {
            if (data instanceof NumberDisplay) {
                NumberDisplay display = (NumberDisplay)data;
                if (coin.matches(display.baseItem)) {
                    coinEntry.addProperty("baseUnit", Boolean.valueOf(true));
                }
            }
        }

        @Override
        @Nonnull
        public NumberDisplay build() throws JsonSyntaxException {
            if (this.format == null) {
                throw new JsonSyntaxException("displayFormat entry is missing or cannot be parsed!");
            }
            if (this.baseUnit == null && this.firstCoin == null) {
                throw new JsonSyntaxException("No coins could be found to be designated as the base unit!");
            }
            return new NumberDisplay(this.format, this.wordyFormat, this.baseUnit == null ? this.firstCoin : this.baseUnit);
        }

        @Nonnull
        private static Pair<String, Boolean> parseFormat(@Nonnull JsonObject json, @Nonnull String key) throws JsonSyntaxException {
            JsonElement element = json.get(key);
            if (element == null) {
                throw new JsonSyntaxException("Missing " + key);
            }
            if (element.isJsonPrimitive()) {
                return Pair.of((Object)GsonHelper.convertToString((JsonElement)element, (String)key), (Object)false);
            }
            JsonObject object = GsonHelper.convertToJsonObject((JsonElement)element, (String)key);
            if (object.has("translate")) {
                return Pair.of((Object)GsonHelper.getAsString((JsonObject)object, (String)"translate"), (Object)true);
            }
            return Pair.of((Object)GsonHelper.getAsString((JsonObject)object, (String)"text"), (Object)false);
        }

        private static void saveFormat(@Nonnull JsonObject json, @Nonnull String key, @Nonnull Pair<String, Boolean> format) {
            if (((Boolean)format.getSecond()).booleanValue()) {
                JsonObject o = new JsonObject();
                o.addProperty("translate", (String)format.getFirst());
                json.add(key, (JsonElement)o);
            } else {
                json.addProperty(key, (String)format.getFirst());
            }
        }
    }
}

