/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.input.templates;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.money.input.MoneyInputHandler;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.DoubleParser;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.TextInputUtil;
import java.text.DecimalFormat;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public abstract class SimpleDisplayInput
extends MoneyInputHandler {
    private Component prefix = EasyText.empty();
    private Component postfix = EasyText.empty();
    private EditBox input;
    private Component error = null;

    protected SimpleDisplayInput() {
    }

    protected void setPrefix(@Nonnull String prefix) {
        this.prefix = EasyText.literal(prefix);
    }

    protected void setPrefix(@Nonnull Component prefix) {
        this.prefix = prefix;
    }

    protected void setPostfix(@Nonnull String postfix) {
        this.postfix = EasyText.literal(postfix);
    }

    protected void setPostfix(@Nonnull Component postfix) {
        this.postfix = postfix;
    }

    @Override
    public void initialize(@Nonnull ScreenArea widgetArea) {
        int postfixWidth;
        int prefixWidth = this.getFont().width((FormattedText)this.prefix);
        if (prefixWidth > 0) {
            prefixWidth += 2;
        }
        if ((postfixWidth = this.getFont().width((FormattedText)this.postfix)) > 0) {
            postfixWidth += 2;
        }
        if (prefixWidth + postfixWidth > widgetArea.width + 40) {
            LightmansCurrency.LogError("Prefix & Postfix are too long. Cannot setup display!\nPrefix: " + this.prefix.getString() + "\nPostfix: " + this.postfix.getString());
            this.error = EasyText.empty().append(this.prefix).append((Component)EasyText.literal("###")).append(this.postfix);
            return;
        }
        this.input = this.addChild(TextInputUtil.doubleBuilder().position(widgetArea.pos.offset(10 + prefixWidth, 22)).width(156 - prefixWidth - postfixWidth).apply(DoubleParser.builder().min(0.0).empty(0.0).consumer()).maxLength(this.maxLength()).handler(this::onValueChanges).startingString(this.getStartingText()).build());
    }

    protected int maxLength() {
        return 32;
    }

    @Override
    public void renderTick() {
        if (this.input == null) {
            return;
        }
        this.input.visible = this.isVisible();
        this.input.active = !this.isFree() && !this.isLocked();
    }

    protected Component getErrorText() {
        return EasyText.literal("DISPLAY FORMAT TOO LONG");
    }

    @Override
    protected void renderBG(@Nonnull ScreenArea widgetArea, @Nonnull EasyGuiGraphics gui) {
        super.renderBG(widgetArea, gui);
        if (this.input == null) {
            if (this.error != null) {
                TextRenderUtil.drawCenteredText(gui, this.getErrorText(), widgetArea.width / 2, widgetArea.height / 2 - 10, 0xFF0000);
                TextRenderUtil.drawCenteredText(gui, this.error, widgetArea.width / 2, widgetArea.height / 2, 0xFF0000);
            }
            return;
        }
        if (this.isFree()) {
            this.input.setValue("");
        }
        if (!this.prefix.getString().isEmpty()) {
            gui.drawShadowed(this.prefix, 10, 28, 0xFFFFFF);
        }
        if (!this.postfix.getString().isEmpty()) {
            int width = gui.font.width((FormattedText)this.postfix);
            gui.drawShadowed(this.postfix, widgetArea.width - 10 - width, 28, 0xFFFFFF);
        }
    }

    private void onValueChanges(double newValueNumber) {
        if (this.isFree()) {
            return;
        }
        MoneyValue newValue = this.getValueFromInput(newValueNumber);
        this.changeValue(newValue);
    }

    @Override
    public void onValueChanged(@Nonnull MoneyValue newValue) {
        double valueNumber = 0.0;
        if (newValue.getUniqueName().equals(this.getUniqueName())) {
            valueNumber = this.getTextFromDisplay(newValue);
        }
        String text = valueNumber % 1.0 == 0.0 ? String.valueOf((long)valueNumber) : String.valueOf(valueNumber);
        if (this.input != null) {
            this.input.setValue(text);
        }
    }

    protected String getStartingText() {
        double value = this.getTextFromDisplay(this.currentValue());
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(this.getRelevantDecimals());
        return df.format(value);
    }

    @Nonnull
    protected abstract MoneyValue getValueFromInput(double var1);

    protected abstract double getTextFromDisplay(@Nonnull MoneyValue var1);

    protected int getRelevantDecimals() {
        return 0;
    }
}

