/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.notifications;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.api.misc.ISidedObject;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationAPI;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class NotificationData
implements ISidedObject {
    private boolean isClient = false;
    List<Notification> notifications = new ArrayList<Notification>();

    @Override
    public boolean isClient() {
        return this.isClient;
    }

    public List<Notification> getNotifications() {
        return this.notifications;
    }

    public List<Notification> getNotifications(NotificationCategory category) {
        if (category == NotificationCategory.GENERAL) {
            return this.notifications;
        }
        return this.getNotifications((Notification n) -> n.getCategory().matches(category));
    }

    public List<Notification> getNotifications(Predicate<Notification> filter) {
        ArrayList<Notification> result = new ArrayList<Notification>();
        for (Notification not : this.notifications) {
            if (!filter.test(not)) continue;
            result.add(not);
        }
        return result;
    }

    public boolean unseenNotification() {
        return this.unseenNotification(NotificationCategory.GENERAL);
    }

    public boolean unseenNotification(NotificationCategory category) {
        for (Notification n : this.getNotifications(category)) {
            if (n.wasSeen()) continue;
            return true;
        }
        return false;
    }

    public List<NotificationCategory> getCategories() {
        ArrayList<NotificationCategory> result = new ArrayList<NotificationCategory>();
        for (Notification not : this.notifications) {
            NotificationCategory category = not.getCategory();
            if (category == null || !result.stream().noneMatch(cat -> cat.matches(category))) continue;
            result.add(category);
        }
        return result;
    }

    public void addNotification(Notification newNotification) {
        Notification mostRecent;
        boolean shouldAdd = true;
        if (!this.notifications.isEmpty() && (mostRecent = this.notifications.getFirst()).onNewNotification(newNotification)) {
            shouldAdd = false;
        }
        if (shouldAdd) {
            this.notifications.addFirst(newNotification);
        }
        this.validateListSize();
    }

    public void deleteNotification(int notificationIndex) {
        if (notificationIndex < 0 || notificationIndex >= this.notifications.size()) {
            return;
        }
        this.notifications.remove(notificationIndex);
    }

    public void deleteNotification(NotificationCategory category, int notificationIndex) {
        if (category == NotificationCategory.GENERAL) {
            this.deleteNotification(notificationIndex);
            return;
        }
        this.deleteNotification((Notification n) -> n.getCategory().matches(category), notificationIndex);
    }

    public void deleteNotification(Predicate<Notification> filter, int notificationIndex) {
        for (int i = 0; i < this.notifications.size(); ++i) {
            Notification n = this.notifications.get(i);
            if (!filter.test(n) || --notificationIndex >= 0) continue;
            this.notifications.remove(i);
            return;
        }
    }

    private void validateListSize() {
        int limit = (Integer)LCConfig.SERVER.notificationLimit.get();
        while (this.notifications.size() > limit) {
            this.notifications.removeLast();
        }
    }

    public CompoundTag save(HolderLookup.Provider lookup) {
        CompoundTag compound = new CompoundTag();
        ListTag notificationList = new ListTag();
        for (Notification notification : new ArrayList<Notification>(this.notifications)) {
            notificationList.add((Object)notification.save(lookup));
        }
        compound.put("Notifications", (Tag)notificationList);
        return compound;
    }

    public static NotificationData loadFrom(CompoundTag compound, HolderLookup.Provider lookup) {
        NotificationData data = new NotificationData();
        data.load(compound, lookup);
        return data;
    }

    public void load(CompoundTag compound, HolderLookup.Provider lookup) {
        if (compound.contains("Notifications", 9)) {
            this.notifications = new ArrayList<Notification>();
            ListTag notificationList = compound.getList("Notifications", 10);
            for (int i = 0; i < notificationList.size(); ++i) {
                CompoundTag notTag = notificationList.getCompound(i);
                Notification not = NotificationAPI.getApi().LoadNotification(notTag, lookup);
                if (not == null) continue;
                this.notifications.add(not);
            }
            this.validateListSize();
            if (this.isClient) {
                this.flagAsClient();
            }
        }
    }

    @Override
    public final NotificationData flagAsClient() {
        return this.flagAsClient(true);
    }

    @Override
    public final NotificationData flagAsClient(boolean isClient) {
        this.isClient = isClient;
        for (Notification n : this.notifications) {
            n.flagAsClient(this);
        }
        return this;
    }

    @Override
    public final NotificationData flagAsClient(IClientTracker context) {
        return this.flagAsClient(context.isClient());
    }
}

