/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.settings.data;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class SavedSettingData {
    public static final Codec<SavedSettingData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.BOOL).fieldOf("booleans").forGetter(data -> data.boolData), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.LONG).fieldOf("integers").forGetter(data -> data.intData), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.DOUBLE).fieldOf("floats").forGetter(data -> data.floatData), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).fieldOf("strings").forGetter(data -> data.stringData), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)CompoundTag.CODEC).fieldOf("compounds").forGetter(data -> data.tagData)).apply((Applicative)builder, SavedSettingData::new));
    public static final StreamCodec<FriendlyByteBuf, SavedSettingData> STREAM_CODEC = StreamCodec.of((b, d) -> {
        SavedSettingData.encodeMap(b, d.boolData, FriendlyByteBuf::writeBoolean);
        SavedSettingData.encodeMap(b, d.intData, FriendlyByteBuf::writeLong);
        SavedSettingData.encodeMap(b, d.floatData, FriendlyByteBuf::writeDouble);
        SavedSettingData.encodeMap(b, d.stringData, FriendlyByteBuf::writeUtf);
        SavedSettingData.encodeMap(b, d.tagData, (a, t) -> a.writeNbt((Tag)t));
    }, b -> {
        Map<String, Boolean> boolData = SavedSettingData.decodeMap(b, FriendlyByteBuf::readBoolean);
        Map<String, Long> intData = SavedSettingData.decodeMap(b, FriendlyByteBuf::readLong);
        Map<String, Double> floatData = SavedSettingData.decodeMap(b, FriendlyByteBuf::readDouble);
        Map<String, String> stringData = SavedSettingData.decodeMap(b, FriendlyByteBuf::readUtf);
        Map<String, CompoundTag> tagData = SavedSettingData.decodeMap(b, a -> a.readNbt());
        return new SavedSettingData(boolData, intData, floatData, stringData, tagData);
    });
    public static final SavedSettingData EMPTY = new SavedSettingData();
    private final Map<String, Boolean> boolData;
    private final Map<String, Long> intData;
    private final Map<String, Double> floatData;
    private final Map<String, String> stringData;
    private final Map<String, CompoundTag> tagData;

    private static <T> void encodeMap(FriendlyByteBuf buffer, Map<String, T> map, BiConsumer<FriendlyByteBuf, T> encoder) {
        buffer.writeInt(map.size());
        map.forEach((key, val) -> {
            buffer.writeUtf(key);
            encoder.accept(buffer, val);
        });
    }

    private static <T> Map<String, T> decodeMap(FriendlyByteBuf buffer, Function<FriendlyByteBuf, T> decoder) {
        HashMap<String, T> map = new HashMap<String, T>();
        int count = buffer.readInt();
        for (int i = 0; i < count; ++i) {
            String key = buffer.readUtf();
            T val = decoder.apply(buffer);
            map.put(key, val);
        }
        return map;
    }

    private SavedSettingData() {
        this.boolData = ImmutableMap.of();
        this.intData = ImmutableMap.of();
        this.floatData = ImmutableMap.of();
        this.stringData = ImmutableMap.of();
        this.tagData = ImmutableMap.of();
    }

    private SavedSettingData(Map<String, Boolean> boolData, Map<String, Long> intData, Map<String, Double> floatData, Map<String, String> stringData, Map<String, CompoundTag> tagData) {
        this.boolData = ImmutableMap.copyOf(boolData);
        this.intData = ImmutableMap.copyOf(intData);
        this.floatData = ImmutableMap.copyOf(floatData);
        this.stringData = ImmutableMap.copyOf(stringData);
        this.tagData = ImmutableMap.copyOf(tagData);
    }

    public boolean hasNode(String node) {
        return !this.getNode(node).isEmpty();
    }

    public NodeAccess getNode(String node) {
        return new NodeAccess(this, node);
    }

    public Mutable makeMutable() {
        return new Mutable(this.boolData, this.intData, this.floatData, this.stringData, SavedSettingData.copyTags(this.tagData));
    }

    public boolean equals(Object obj) {
        if (obj instanceof SavedSettingData) {
            SavedSettingData other = (SavedSettingData)obj;
            return this.boolData.equals(other.boolData) && this.intData.equals(other.intData) && this.floatData.equals(other.floatData) && this.stringData.equals(other.stringData) && this.tagData.equals(other.tagData);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.boolData, this.intData, this.floatData, this.stringData, this.tagData);
    }

    private static boolean hasNodeEntry(Map<String, ?> map, String node) {
        return map.keySet().stream().anyMatch(key -> key.startsWith(node));
    }

    private static Map<String, CompoundTag> copyTags(Map<String, CompoundTag> original) {
        HashMap<String, CompoundTag> copy = new HashMap<String, CompoundTag>();
        original.forEach((key, tag) -> copy.put((String)key, tag.copy()));
        return copy;
    }

    public static final class NodeAccess {
        private final SavedSettingData data;
        private final String node;

        private NodeAccess(SavedSettingData data, String node) {
            this.data = data;
            this.node = node + ".";
        }

        public NodeAccess forSubNode(String subNode) {
            return new NodeAccess(this.data, this.node + "." + subNode);
        }

        private boolean hasNodeEntry(Map<String, ?> map) {
            return SavedSettingData.hasNodeEntry(map, this.node);
        }

        public boolean isEmpty() {
            return !this.hasNodeEntry(this.data.boolData) && !this.hasNodeEntry(this.data.intData) && !this.hasNodeEntry(this.data.floatData) && !this.hasNodeEntry(this.data.stringData) && !this.hasNodeEntry(this.data.tagData);
        }

        public boolean hasBoolValue(String tag) {
            return this.data.boolData.containsKey(this.node + tag);
        }

        public boolean hasIntValue(String tag) {
            return this.data.intData.containsKey(this.node + tag);
        }

        public boolean hasLongValue(String tag) {
            return this.data.intData.containsKey(this.node + tag);
        }

        public boolean hasFloatValue(String tag) {
            return this.data.floatData.containsKey(this.node + tag);
        }

        public boolean hasDoubleValue(String tag) {
            return this.data.floatData.containsKey(this.node + tag);
        }

        public boolean hasStringValue(String tag) {
            return this.data.stringData.containsKey(this.node + tag);
        }

        public boolean hasCompoundValue(String tag) {
            return this.data.tagData.containsKey(this.node + tag);
        }

        public boolean getBooleanValue(String tag) {
            return this.data.boolData.getOrDefault(this.node + tag, false);
        }

        public int getIntValue(String tag) {
            return this.data.intData.getOrDefault(this.node + tag, 0L).intValue();
        }

        public long getLongValue(String tag) {
            return this.data.intData.getOrDefault(this.node + tag, 0L);
        }

        public float getFloatValue(String tag) {
            return this.data.floatData.getOrDefault(this.node + tag, 0.0).floatValue();
        }

        public double getDoubleValue(String tag) {
            return this.data.floatData.getOrDefault(this.node + tag, 0.0);
        }

        public String getStringValue(String tag) {
            return this.data.stringData.getOrDefault(this.node + tag, "");
        }

        public CompoundTag getCompoundValue(String tag) {
            return this.data.tagData.getOrDefault(this.node + tag, new CompoundTag());
        }
    }

    public static final class Mutable {
        private final Map<String, Boolean> boolData;
        private final Map<String, Long> intData;
        private final Map<String, Double> floatData;
        private final Map<String, String> stringData;
        private final Map<String, CompoundTag> tagData;

        public MutableNodeAccess getNode(String node) {
            return new MutableNodeAccess(this, node);
        }

        private Mutable(Map<String, Boolean> boolData, Map<String, Long> intData, Map<String, Double> floatData, Map<String, String> stringData, Map<String, CompoundTag> tagData) {
            this.boolData = new HashMap<String, Boolean>(boolData);
            this.intData = new HashMap<String, Long>(intData);
            this.floatData = new HashMap<String, Double>(floatData);
            this.stringData = new HashMap<String, String>(stringData);
            this.tagData = new HashMap<String, CompoundTag>(tagData);
        }

        public void merge(SavedSettingData data) {
            this.boolData.putAll(data.boolData);
            this.intData.putAll(data.intData);
            this.floatData.putAll(data.floatData);
            this.stringData.putAll(data.stringData);
            this.tagData.putAll(SavedSettingData.copyTags(data.tagData));
        }

        public SavedSettingData makeImmutable() {
            return new SavedSettingData(this.boolData, this.intData, this.floatData, this.stringData, SavedSettingData.copyTags(this.tagData));
        }
    }

    public static final class MutableNodeAccess {
        private final Mutable data;
        private final String node;

        private MutableNodeAccess(Mutable data, String node) {
            this.data = data;
            this.node = node + ".";
        }

        public MutableNodeAccess forSubNode(String subNode) {
            return new MutableNodeAccess(this.data, this.node + "." + subNode);
        }

        public boolean hasBoolValue(String tag) {
            return this.data.boolData.containsKey(this.node + tag);
        }

        public boolean hasIntValue(String tag) {
            return this.data.intData.containsKey(this.node + tag);
        }

        public boolean hasLongValue(String tag) {
            return this.data.intData.containsKey(this.node + tag);
        }

        public boolean hasFloatValue(String tag) {
            return this.data.floatData.containsKey(this.node + tag);
        }

        public boolean hasDoubleValue(String tag) {
            return this.data.floatData.containsKey(this.node + tag);
        }

        public boolean hasStringValue(String tag) {
            return this.data.stringData.containsKey(this.node + tag);
        }

        public boolean hasCompoundValue(String tag) {
            return this.data.tagData.containsKey(this.node + tag);
        }

        public boolean getBooleanValue(String tag) {
            return this.data.boolData.getOrDefault(this.node + tag, false);
        }

        public int getIntValue(String tag) {
            return this.data.intData.getOrDefault(this.node + tag, 0L).intValue();
        }

        public long getLongValue(String tag) {
            return this.data.intData.getOrDefault(this.node + tag, 0L);
        }

        public float getFloatValue(String tag) {
            return this.data.floatData.getOrDefault(this.node + tag, 0.0).floatValue();
        }

        public double getDoubleValue(String tag) {
            return this.data.floatData.getOrDefault(this.node + tag, 0.0);
        }

        public String getStringValue(String tag) {
            return this.data.stringData.getOrDefault(this.node + tag, "");
        }

        public CompoundTag getCompoundValue(String tag) {
            return this.data.tagData.getOrDefault(this.node + tag, new CompoundTag());
        }

        public void setBooleanValue(String tag, boolean value) {
            this.data.boolData.put(this.node + tag, value);
        }

        public void setIntValue(String tag, int value) {
            this.data.intData.put(this.node + tag, Long.valueOf(value));
        }

        public void setLongValue(String tag, long value) {
            this.data.intData.put(this.node + tag, value);
        }

        public void setFloatValue(String tag, float value) {
            this.data.floatData.put(this.node + tag, Double.valueOf(value));
        }

        public void setDoubleValue(String tag, double value) {
            this.data.floatData.put(this.node + tag, value);
        }

        public void setStringValue(String tag, String value) {
            this.data.stringData.put(this.node + tag, value);
        }

        public void setCompoundValue(String tag, CompoundTag value) {
            this.data.tagData.put(this.node + tag, value.copy());
        }
    }
}

