/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders.settings.builtin;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.settings.data.LoadContext;
import io.github.lightman314.lightmanscurrency.api.settings.data.SavedSettingData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.settings.EasyTraderSettingsNode;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class AllySettings
extends EasyTraderSettingsNode<TraderData> {
    public AllySettings(TraderData trader) {
        super("allies", trader, 505);
    }

    @Override
    public MutableComponent getName() {
        return LCText.DATA_CATEGORY_TRADER_ALLIES.get(new Object[0]);
    }

    @Override
    protected String getRequiredPermission() {
        return "addRemoveAllies";
    }

    @Override
    public void saveSettings(SavedSettingData.MutableNodeAccess data) {
        CompoundTag tag = new CompoundTag();
        PlayerReference.saveList(tag, this.trader.getAllies(), "Allies");
        data.setCompoundValue("allies", tag);
    }

    @Override
    public void loadSettings(SavedSettingData.NodeAccess data, LoadContext context) {
        if (data.hasCompoundValue("allies")) {
            CompoundTag tag = data.getCompoundValue("allies");
            this.trader.overwriteAllies(PlayerReference.loadList(tag, "Allies"));
        }
    }

    @Override
    protected void writeLines(SavedSettingData.NodeAccess data, Consumer<Component> lineWriter) {
        if (data.hasCompoundValue("allies")) {
            CompoundTag tag = data.getCompoundValue("allies");
            int count = 0;
            if (tag.contains("Allies", 9)) {
                count = tag.getList("Allies", 10).size();
            }
            lineWriter.accept((Component)AllySettings.formatEntry((Component)LCText.DATA_ENTRY_ALLIES.get(new Object[0]), (Component)LCText.DATA_ENTRY_ALLIES_COUNT.get(count)));
        }
    }
}

